
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectString = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectString:new(...)
  SetPostEffectString.super.new(self, ...)

end

function SetPostEffectString:_OnUpdate(args)

  --这里args[3] 在编译时转成了绝对路径~
  args[1]:SetParameter(args[2], args[3]);

end



function SetPostEffectString:_IsRightType(value)
  --后处理的参数可能为字符串 存储纹理路径...  在process中创建纹理
  --comic.lua的lutPath
  return type(value) == "string";
end



SetPostEffectString:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectString:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); --instance可选的vector3变量
SetPostEffectString:RegisterInput(3, Types.Tex2DPathType, "Tex2D Path", "根据纹理路径创建纹理", "DEVICE_CAPTURE");


SetPostEffectString:RegisterExecInput(1, "exec", "执行");

SetPostEffectString:RegisterExecOutput(1, "exec", "执行");

SetPostEffectString:SetFunctionName("SetPostEffectString");


return SetPostEffectString ;

