local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetParamFloat = BlueNode:extend();

function SetParamFloat:new(...)
    SetParamFloat.super.new(self, ...);
end

function SetParamFloat:_OnUpdate(args)
    args[1]:SetFloatValue(args[2], args[3]);
end

SetParamFloat:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "target", "动画组件", BlueSelf());
SetParamFloat:RegisterInput(2, Types.StringType, "ParamName", "参数名字", "");
SetParamFloat:RegisterInput(3, Types.FloatType, "Float Value", "设置Float类型参数", 0.0);
SetParamFloat:RegisterExecInput(1, "exec", "Execute");
SetParamFloat:RegisterExecOutput(1, "exec", "Execute");
SetParamFloat:SetFunctionName("SetParamFloat");

return SetParamFloat;
