local libvenuscore = require "libvenuscore"

local BlueDumper = {}
local BU = require "bluecore.blueutility"
local BD = require "bluecore.bluedefined"

BlueDumper.dump = function(blueprint)

  -- 打印目前的ID
  LOG("UID: " .. tostring(blueprint._UID))

  -- 打印Node总数
  local sum = 0
  for _, k in pairs(blueprint.bluePrintNodeList) do
    if k ~= nil then
      sum = sum + 1
    end
  end
  LOG("bluePrintNodeList: " .. tostring(sum))

  -- 打印各个Node的信息
  for _, node in pairs(blueprint.bluePrintNodeList) do

    LOG("node " .. tostring(node.uid) .. "," .. tostring(node:GetName()))

    if type(node.luaPath) ~= 'string' then
      LOG("--- class: " ..tostring(node.luaPath:GetObjectID()));
    end

    if node ~= nil then

      LOG("--- input ")
      if node.inputs ~= nil then
        for _, input in pairs(node.inputs) do

          if not input.pinType or not input.argId then
            LOG(node.name);
            LOG(node.uid);
            LOG("xxxx");
          end
          local pinInfo = node.infoTable[input.pinType][input.argId]
          if pinInfo then
            local BlueRtti = require "bluecore.core.blue_rtti"
            local typeName = BlueRtti.GetRealTypeName(pinInfo.rtti)
            LOG("    |---- " .. tostring(pinInfo.name) .. "," .. tostring(pinInfo.argId) .. "," .. tostring(input.uid) .. "," .. typeName)
          else
            ERROR("    |---- " .. "Err");
          end

          if input.useLiteral then

            if BU:isBlueSelf(input.literal) then
              local inputInfo = node.infoTable[input.pinType][input.argId]
              if not inputInfo.rtti:isTypeOrDriverType(blueprint._selfClass) then
                ERROR("          |----(literal)(self not match)") -- 代表这个引脚是self 但是跟当前蓝图类不匹配
              else
                LOG("          |----(literal)(self match)")
              end
            else
              LOG("          |----(literal)" .. tostring(input.literal))
            end

            if input.links ~= nil then
              -- 使用literal的情况下 不应该有连线的
              for _, lnk in pairs(input.links) do
                -- 因为数据输入只有一个,所以创建时候会有{},但是pin和node为nil
                if lnk.pin ~= nil then
                  ERROR("          |----(err)" .. tostring(lnk.pinUid))
                end
              end
            end

          else
            if input.links ~= nil then
              for _, lnk in pairs(input.links) do
                -- 因为数据输入只有一个,所以创建时候会有{},但是pin和node为nil
                LOG("          |----" .. tostring(lnk.pinUid))
              end
            end
          end

        end
      end

      LOG("--- output ")
      if node.outputs ~= nil then
        for _, output in pairs(node.outputs) do
          local pinInfo = node.infoTable[output.pinType][output.argId]
          if pinInfo ~= nil then
            local BlueRtti = require "bluecore.core.blue_rtti"
            local typeName = BlueRtti.GetRealTypeName(pinInfo.rtti)
            LOG("    |---- " .. tostring(pinInfo.name) .. "," .. tostring(pinInfo.argId) .. "," .. tostring(output.uid) .. "," .. typeName)
          else
            ERROR("    |---- " .. "(Err)")
          end

          if node.nodeType == BD.COMPONENT_NODE then
            if libvenuscore.isNil(node.comp) then
              ERROR("          (" .. "Err:component is lost)")
            else
              LOG("          (" .. "component ref "..tostring(node.comp)..")")
            end
          end

          if node.nodeType == BD.REF_NODE then
            if libvenuscore.isNil(node.refNode) then
              ERROR("          (" .. "Err:node is lost)")
            else
              LOG("          (" .. "node ref "..tostring(node.refNode)..")")
            end
          end

          if output.links ~= nil then
            for _, lnk in pairs(output.links) do
              LOG("          |----" .. tostring(lnk.pinUid))
            end
          end
        end
      end

      LOG("--- exeInput ")
      if node.execInputs ~= nil then
        for _, execInput in pairs(node.execInputs) do
          local pinInfo = node.infoTable[execInput.pinType][execInput.argId]
          LOG("    |---- " .. tostring(pinInfo.name) .. "," .. tostring(pinInfo.argId) .. "," .. tostring(execInput.uid))
          if execInput.links ~= nil then
            -- 如果上面有引脚信息,但是没有link信息,那么说明这个引脚没有任何连接
            for _, lnk in pairs(execInput.links) do
              LOG("          |----" .. tostring(lnk.pinUid))
            end
          end
        end
      end

      LOG("--- execOutput ")
      if node.execOutputs ~= nil then
        for _, execOutput in pairs(node.execOutputs) do
          local pinInfo = node.infoTable[execOutput.pinType][execOutput.argId]
          LOG("    |---- " .. tostring(pinInfo.name) .. "," .. tostring(pinInfo.argId) .. "," .. tostring(execOutput.uid))
          if execOutput.links ~= nil then
            for _, lnk in pairs(execOutput.links) do
              -- 因为执行输出只有一个,所以创建时候会有{},但是pin和node为nil
              LOG("          |----" .. tostring(lnk.pinUid))
            end
          end
        end
      end

      LOG("--- group ")
      if node.pinGroup ~= nil then
        for name, grp in pairs(node.pinGroup) do
          LOG("    |---- " .. tostring(name))
          if #grp ~= 0 then
            for _, gfo in pairs(grp) do
              LOG("          |----" .. tostring(gfo.pinUid))
            end
          end
        end
      end

    end
  end

  sum = 0
  if blueprint.bluePrintEventGraph ~= nil then
    for _, k in pairs(blueprint.bluePrintEventGraph) do
      if k ~= nil then
        sum = sum + 1
      end
    end
  end
  LOG("bluePrintEventGraph: " .. tostring(sum))

  for _, eventNode in pairs(blueprint.bluePrintEventGraph) do
    LOG("--- " .. tostring(eventNode.uid) .. "," .. tostring(eventNode:GetName()))
  end

  sum = 0
  if blueprint.bluePrintLinkList ~= nil then
    for _, k in pairs(blueprint.bluePrintLinkList) do
      if k ~= nil then
        sum = sum + 1
      end
    end
  end
  LOG("bluePrintLinkList: " .. tostring(sum))
  if sum > 0 then
    for _, link in pairs(blueprint.bluePrintLinkList) do
      LOG("--- " .. tostring(link[BD.LINK_UID]) .. ": " .. tostring(link[BD.LINK_START]) .. " -> " .. tostring(link[BD.LINK_END]))
    end
  end

  sum = 0
  if blueprint.bluePrintAllList ~= nil then
    for _, k in pairs(blueprint.bluePrintAllList) do
      if k ~= nil then
        sum = sum + 1
      end
    end
  end
  LOG("bluePrintAllList: " .. tostring(sum))
  if sum > 0 then
    for _, item in pairs(blueprint.bluePrintAllList) do
      if item ~= nil then
        local obj = ""
        if blueprint.bluePrintLinkList[item.uid] ~= nil then
          obj = obj .. " link"
        end
        if blueprint.bluePrintNodeList[item.uid] ~= nil then
          obj = obj .. " node," .. tostring(item:GetName())
        end
        if item.argId ~= nil then
          -- 如果是引脚 应该有info字段

          local owner = blueprint.bluePrintNodeList[item.nodeUid]
          local is_valid = false

          if blueprint.bluePrintNodeList[owner.uid] ~= nil then
            local process = function(pins)
              if pins ~= nil then
                for _, pin in pairs(pins) do
                  if pin == item then
                    return true
                  end
                end
                return false
              end
            end
            is_valid = (is_valid or process(owner.inputs))
            is_valid = (is_valid or process(owner.outputs))
            is_valid = (is_valid or process(owner.execInputs))
            is_valid = (is_valid or process(owner.execOutputs))
          end
          local pinInfo = blueprint:GetPinInfo(item)
          obj = obj .. " pin," .. tostring(pinInfo.name)
          if not is_valid then
            obj = obj .. " [invalid pin][node:" .. owner:GetName() .. "," .. owner.uid .. "]"
          end
        end
        LOG("--- " .. tostring(item.uid) .. ": " .. tostring(obj)) --正常情况应该obj/lnk/node有且只有一个
      end
    end
  end

  BlueDumper.dumpVariable(blueprint);

end


BlueDumper.dumpVariable = function(blueprint)

  local sum = 0
  if blueprint.bluePrintVariableList ~= nil then
    for _, k in pairs(blueprint.bluePrintVariableList) do
      if k ~= nil then
        sum = sum + 1
      end
    end
  end

  LOG("variable: (total:"..tostring(sum)..")");

  local list = blueprint.bluePrintVariableList
  for _, varinfo in pairs(list) do
    LOG("")
    LOG("--- name: "..tostring(varinfo:GetName()))
    LOG("--- hash: "..tostring(varinfo:GetObjectID()))
    LOG("--- rtti: ".. varinfo.rtti:GetTypeName());
    LOG("--- base_rtti_name: "..varinfo.base_rtti_name);
    LOG("--- base_rtti: "..varinfo.base_rtti:GetTypeName());
    LOG("--- is_array: "..tostring(varinfo.is_array));
    LOG("--- is_private: "..tostring(varinfo.is_private));
    LOG("--- is_const: "..tostring(varinfo.is_const));
    LOG("--- is_final: "..tostring(varinfo.is_final));
    LOG("--- tips: "..tostring(varinfo.tips));
    if varinfo.is_array then
      LOG("--- default:(array) ");
      for idx , value in pairs(varinfo.default_value) do
        LOG("------"..tostring(idx).."---: ");
        assert( type(value) == 'table' and value.GetTypeName, "array item must be ArrayItemWrap")
        value = value.value
        if type(value) == 'table' and value.GetTypeName then
          for subKey, subValue in libvenuscore.mpairs(value) do
            LOG("--------- "..tostring(subKey)..","..tostring(subValue))
          end
        else
          LOG("--------- "..tostring(value))
        end
      end
    else
      if type(varinfo.default_value) == 'table' and varinfo.default_value.GetTypeName then
        LOG("--- default: ");
        for subKey, subValue in libvenuscore.mpairs(varinfo.default_value) do
          LOG("--------- "..tostring(subKey)..","..tostring(subValue))
        end
      else
        LOG("--- default: "..tostring(varinfo.default_value));
      end
    end

  end
end


local function GetDepthPrefix(depth)
  local str = ""
  for i = 0 , depth do
    str = str .. "|    "
  end
  return str
end


local function GetParentPrefix()
  return "|----"
end


local function GetHiddenPrefix()
  return "|    "
end

local function GetHiddenPrefix2()
  return "|        "
end



local function DumpPinInfo(pinInfo, prefix)
  LOG(prefix.."")
  LOG(prefix.."^ pinType: "..tostring(BU:PinTypeToString(pinInfo.pinType)))
  LOG(prefix.."^   argId: "..tostring(pinInfo.argId))
  LOG(prefix.."^    rtti: "..tostring(pinInfo.rtti:GetTypeName()))
  LOG(prefix.."^    name: "..tostring(pinInfo.name))
  LOG(prefix.."^    tips: "..tostring(pinInfo.tips))
  if (pinInfo.pinType == BD.PIN_DATA_INPUT) then
    LOG(prefix.."^ default: "..tostring(pinInfo.default))
    if pinInfo.groupName ~= nil then LOG(prefix.."^   group: "..tostring(pinInfo.groupName)) end
  elseif (pinInfo.pinType == BD.PIN_EXEC_INPUT) then
    if pinInfo.abort ~= nil then LOG(prefix.."^   abort: "..tostring(pinInfo.abort)) end
  end
  LOG(prefix.."")
end

-- 打印 给定蓝图上下文菜单的信息(支持创建节点列表)
BlueDumper.dumpContext = function(blueprint)

  local stack = {}
  for _, directory in pairs(blueprint.myContextNodeAll) do
    local stackInfo = {
      directory = directory,
      depth = 1,
    }
    table.insert(stack, stackInfo) -- 第一层都是目录
  end

  while #stack > 0 do
    local stackInfo = table.remove(stack)
    local directory = stackInfo.directory
    for dirName , item in pairs(directory) do
      if item.blueNodeName ~= nil then
        local prefix = GetDepthPrefix(stackInfo.depth)
        local nodePrefix = prefix..GetParentPrefix()
        local pinPrefix = prefix..GetHiddenPrefix();

        WARNING(nodePrefix.."NodeName:"..tostring(item.blueNodeName))
        LOG(pinPrefix.."NodeType:"..tostring(item.blueNodeType))
        LOG(pinPrefix.."NodeClass:"..tostring(type(item.luaPath)=='string' and item.luaPath or item[BD.LUA_CLASS_PATH]))

        local nodeClass = type(item.luaPath)=='string' and require(item.luaPath) or item.luaPath

        assert(  nodeClass.GetInputsType ~= nil,"nodeClass error ");

        local infoList = {
          nodeClass:GetInputsType(), nodeClass:GetOutputsType(),
          nodeClass:GetExecInput(), nodeClass:GetExecOutput()
        }

        for _, infoItem in pairs(infoList) do
          for _ , info in pairs(infoItem) do
            DumpPinInfo(info, pinPrefix);
          end
        end

      else
        local stackInfo1 = {
          directory = item,
          depth = stackInfo.depth + 1 ,
        }
        LOG(GetDepthPrefix(stackInfo.depth)..GetParentPrefix()..tostring(dirName))
        table.insert(stack, stackInfo1)
      end
    end
  end
end


BlueDumper.dumpClassifyContext = function(blueContext)

  local stack = {}
  local stackInfoRoot = {
    dirName = "Root",
    items = blueContext.myContextNodeClassify,
    depth = 1,
  }
  table.insert(stack, stackInfoRoot) --  BD.BLUE_MGR_DIR 是 目录名字--table


  while #stack > 0 do
    local stackInfo = table.remove(stack)
    local items = stackInfo.items
    local prefix = GetDepthPrefix(stackInfo.depth)
    local rttiPrefix = prefix..GetParentPrefix()
    local nodePrefix = prefix..GetHiddenPrefix2();

    WARNING(prefix..tostring(stackInfo.dirName))
    if items[BD.BLUE_MGR_INPUT] ~= nil  then
      -- 按rtti分类
      LOG(prefix.." in: ")
      for rttiName, infos in pairs(items[BD.BLUE_MGR_INPUT]) do
        LOG(rttiPrefix..tostring(rttiName))
        for _, info in pairs(infos) do
          local nodeClass = type(info.luaPath)=='string' and require(info.luaPath) or info.luaPath
          LOG(nodePrefix..tostring(nodeClass:GetName()))
        end
      end
    end
    if items[BD.BLUE_MGR_OUTPUT] ~= nil  then
      LOG(prefix.." out: ")
      for rttiName, infos in pairs(items[BD.BLUE_MGR_OUTPUT]) do
        LOG(rttiPrefix..tostring(rttiName))
        for _, info in pairs(infos) do
          local nodeClass = type(info.luaPath)=='string' and require(info.luaPath) or info.luaPath
          LOG(nodePrefix..tostring(nodeClass:GetName()))
        end
      end
    end
    if items[BD.BLUE_MGR_DIR] ~= nil then -- 有目录
      for dirName2, items2 in pairs(items[BD.BLUE_MGR_DIR]) do
        local stackInfo2 = {
          dirName = dirName2,
          items = items2,
          depth = stackInfo.depth + 1 ,
        }
        table.insert(stack, stackInfo2)
      end
    end
  end
end


return BlueDumper