
local ae = require "apolloengine"
local mf = require "mathfunction"

local tunes = {}

local F = 1.0 / 255.0

function tunes:Initialize(host, size)

  self.renderObject = nil
  self.Queue = 100

  self.colorDark   = mf.vector3(255.0, 0.0, 0.0)
  self.colorMiddle = mf.vector3(0.0, 255.0, 0.0)
  self.colorLight  = mf.vector3(0.0, 0.0, 255.0)
  self.blendFactor = mf.vector1(100.0)

  self.lastColorDark   = nil
  self.lastColorMiddle = nil
  self.lastColorLight  = nil
  self.lastBlendFactor = nil

  self.TUNES_COLOR_DARK = self.colorDark
  self.TUNES_COLOR_MIDDLE = self.colorMiddle
  self.TUNES_COLOR_LIGHT = self.colorLight
  self.TUNES_ORIGIN_PERCENTAGE = self.blendFactor

  self.lastTUNES_COLOR_DARK = nil
  self.lastTUNES_COLOR_MIDDLE = nil
  self.lastTUNES_COLOR_LIGHT = nil
  self.lastTUNES_ORIGIN_PERCENTAGE = nil

  self.COLOR_DARK = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "COLOR_DARK");

  self.COLOR_MIDDLE = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "COLOR_MIDDLE");

  self.COLOR_LIGHT = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "COLOR_LIGHT");

  self.BLEND_FACTOR = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "BLEND_FACTOR");

  self.material = host:CreateMaterial("comm:documents/material/tunes.material")
  self.renderObject = host:CreateRenderObject()
  
  self.POST_EFFECT_ALPHA = ae.IMaterialSystem:NewParameterSlot(
        ae.ShaderEntity.UNIFORM,
        "POST_EFFECT_ALPHA");
  self.material:SetParameter(self.POST_EFFECT_ALPHA, mf.vector1(1.0));

  self:UpdateParameters()
  
  host:RegisterScriptParameter(self,"colorDark");
  host:RegisterScriptParameter(self,"colorMiddle");
  host:RegisterScriptParameter(self,"colorLight");
  host:RegisterScriptParameter(self,"blendFactor");

  return self.Queue
end

function tunes:Resizeview(size)

end

function tunes:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, ae.RenderTargetEntity.CF_COLOR);


  self.material:SetParameter(
          ae.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));

  self:UpdateParameters()
  
  context:Draw(self.renderObject, self.material);
  context:EndRenderPass();
end

function tunes:UpdateParameters()
  if self.colorDark ~= self.lastColorDark then
    self.material:SetParameter(self.COLOR_DARK,   self.colorDark * F)
    self.lastColorDark = self.colorDark
  end
  if self.colorMiddle ~= self.lastColorMiddle then
    self.material:SetParameter(self.COLOR_MIDDLE, self.colorMiddle * F)
    self.lastColorMiddle = self.colorMiddle
  end
  if self.colorLight ~= self.lastColorLight then
    self.material:SetParameter(self.COLOR_LIGHT,  self.colorLight * F)
    self.lastColorLight = self.colorLight
  end
  if self.blendFactor ~= self.lastBlendFactor then
    self.material:SetParameter(self.BLEND_FACTOR, mf.vector1(self.blendFactor:x() * 0.01))
    self.lastBlendFactor = self.blendFactor
  end
  if self.TUNES_COLOR_DARK ~= self.lastTUNES_COLOR_DARK then
    self.material:SetParameter(self.COLOR_DARK,   self.TUNES_COLOR_DARK * F)
    self.lastTUNES_COLOR_DARK = self.TUNES_COLOR_DARK
  end
  if self.TUNES_COLOR_MIDDLE ~= self.lastTUNES_COLOR_MIDDLE then
    self.material:SetParameter(self.COLOR_MIDDLE, self.TUNES_COLOR_MIDDLE * F)
    self.lastTUNES_COLOR_MIDDLE = self.TUNES_COLOR_MIDDLE
  end
  if self.TUNES_COLOR_LIGHT ~= self.lastTUNES_COLOR_LIGHT then
    self.material:SetParameter(self.COLOR_LIGHT,  self.TUNES_COLOR_LIGHT * F)
    self.lastTUNES_COLOR_LIGHT = self.TUNES_COLOR_LIGHT
  end
  if self.TUNES_ORIGIN_PERCENTAGE ~= self.lastTUNES_ORIGIN_PERCENTAGE then
    self.material:SetParameter(self.BLEND_FACTOR, mf.vector1(self.TUNES_ORIGIN_PERCENTAGE:x() * 0.01))
    self.lastTUNES_ORIGIN_PERCENTAGE = self.TUNES_ORIGIN_PERCENTAGE
  end
end

return tunes;