local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local ComicCombine = {}
ComicCombine.Do = 0;
ComicCombine.DoRenderObj = 0; 
ComicCombine.DoMaterial = 0;
ComicCombine.Queue = 310;

function ComicCombine:Initialize(host, size)

  self.sigma_r = mathfunction.vector1(0.0);
  self.SourceTex = apolloengine.TextureEntity();

  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  self.SIGMA_R = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIGMA_R");
 
  self.TEXTURE_DIFFUSE2 = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TEXTURE_DIFFUSE2");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/comic_combine.material");
  --self.Do = host:CreateRenderObject(pathout);
  self.DoRenderObj = host:CreateRenderObject();
  self.DoMaterial = host:CreateMaterial(pathout);

  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
  self.DoMaterial:SetParameter(self.SIGMA_R, self.sigma_r);
  self.DoMaterial:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);

  host:RegisterScriptParameter(self,"sigma_r");
  host:RegisterScriptParameter(self, "SourceTex");
  return self.Queue;
end



function ComicCombine:Resizeview(size)
  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
end

function ComicCombine:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget();
  --Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.DoMaterial:SetParameter(self.SIGMA_R, self.sigma_r);
  self.DoMaterial:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
	--self.Do:Draw(pipeline);
  context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();
end

return ComicCombine;