require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local blendlayer = {}


local reflector = {
  uiType = "Combo",
  value = {
    Normal = 1,
    Add = 2,
    Lighten = 3 ,
    Multiply = 4 ,
    Overlay = 5,
    Screen = 6 ,
    Lighter = 7 ,
  }
} 

function blendlayer:Initialize(host, size)
  self.renderObject = nil;
  self.material = nil;
  self.Queue = 100;

  self.POST_EFFECT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");

  --self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/blendmode.material");
  self.material = host:CreateMaterial("comm:documents/shaders/posteffect/blendmode.material");
  self.renderObject = host:CreateRenderObject();
  
  self.BlendTex = apolloengine.TextureEntity();
  self.BlendOpacity = mathfunction.vector1(1.0);
  self.BlendMode = mathfunction.vector1(1.0);

  self.material:SetParameter(self.POST_EFFECT_ALPHA, mathfunction.vector1(1.0));
  
  host:RegisterScriptParameter(self, "BlendTex");
  host:RegisterScriptParameter(self, "BlendOpacity");
  host:RegisterScriptParameter(self, "BlendMode",reflector);

  return self.Queue;
end

function blendlayer:Resizeview(size)
--firstmaterialentity:SetParameter("_MainTex", tex);
end

function blendlayer:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget();
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

  --local materials = self.renderObject.MaterialEntities;
  --local material = materials[1];
  --material:SetParameter("_MainTex", Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  --material:SetParameter("_BlendTex", self.BlendTex);
  --material:SetParameter("_BlendOpacity", self.BlendOpacity);
  --material:SetParameter("_BlendMode", self.BlendMode);
  self.material:SetParameter("_MainTex", Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  self.material:SetParameter("_BlendTex", self.BlendTex);
  self.material:SetParameter("_BlendOpacity", self.BlendOpacity);
  self.material:SetParameter("_BlendMode", self.BlendMode);
  
  --self.renderObject:Draw(pipeline);
  context:Draw(self.renderObject, self.material);
  context:EndRenderPass();

end

return blendlayer;