local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local bloom = {}
bloom.RoLumi = 0
bloom.RoGuassX = 0
bloom.RoGuassY = 0
bloom.RoCombine = 0
bloom.Rt1 = 0;
bloom.Rt2 = 0;

bloom.Queue = 500;

function bloom:Initialize(host, size)
  
  local mode = {
      uiType = "Combo",
      value = {
                OriColor = 1,
                SelectColor = 2,
              }
    }

  local colorselect = {
        uiType = "ColorSelector",
    } 

  local drag_float_min_max = {
        uiType = "DragFloatMinMax",
        min=0,
        max=1,
    }
  
  self.bloomMode = mathfunction.vector1(1.0);
  self.bloomcolor = mathfunction.vector4(1,0,0,0);
  self.step = mathfunction.vector2( 1.0, 1.0 );
  self.luminance = mathfunction.vector1( 0.6 );
  self.intensity = mathfunction.vector1( 1.0 );
  self.radius = mathfunction.vector1( 2.0 );
  self.scale1 = mathfunction.vector2( 0.25, 0.25 );
  self.scale2 = mathfunction.vector2( 0.125, 0.125 );
  
  self.BLOOM_MODE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLOOM_MODE");

  self.BLOOM_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLOOM_COLOR");

  self._MainTex = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "_MainTex");

  self.COMBINE_WEIRHT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "COMBINE_WEIRHT");
    
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
    
  self.LUMINANCE_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LUMINANCE_THRESHOLD");
    
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE"); 
      
  self.SIGMA = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "SIGMA");
  
  self.targetsize = size / 4;
  self.targetsize2 = size / 8;
  local GuassStep = mathfunction.vector2( 1.0, 1.0 ) / self.targetsize;
  local combineweight = mathfunction.vector2( 1.0, self.intensity:x());

  self.RenderObj = host:CreateRenderObject();
  self.RoLumi = host:CreateMaterial( "comm:documents/material/luminance_oricolor.material" );
  self.RoLumi:SetParameter(self.BLOOM_MODE, mathfunction.vector1( self.bloomMode:x()) );
  self.RoLumi:SetParameter(self.BLOOM_COLOR, mathfunction.vector3(self.bloomcolor:x(), self.bloomcolor:y(), self.bloomcolor:z()) );
  self.RoLumi:SetParameter(self.LUMINANCE_THRESHOLD, mathfunction.vector1( self.luminance:x()) );
  
  self.RoGuassX = host:CreateMaterial( "comm:documents/material/gaussbloom.material" );
  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
  self.RoGuassX:SetParameter( self.SIGMA, mathfunction.vector1( self.radius:x()) );
	
  self.RoGuassY = host:CreateMaterial( "comm:documents/material/gaussbloom.material" );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
  self.RoGuassY:SetParameter( self.SIGMA, mathfunction.vector1( self.radius:x()) );

  self.RoCombine = host:CreateMaterial( "comm:documents/material/combine.material" );
  self.RoCombine:SetParameter( self.COMBINE_WEIRHT, combineweight );

  self.Rt1 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_A,
        mathfunction.vector4(self.targetsize:x(),self.targetsize:y(),0,0),
        self.targetsize,
        self.scale1), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_A,
        self.targetsize));
    
  self.Rt2 = host:CreateRenderTarget( 
     apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_B,
        mathfunction.vector4(self.targetsize:x(),self.targetsize:y(),0,0),
        self.targetsize,
        self.scale1), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_B,
        self.targetsize));
    
  self.Rt3 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_C,
        mathfunction.vector4(self.targetsize2:x(),self.targetsize2:y(),0,0),
        self.targetsize2,
        self.scale2), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_C,
        self.targetsize2));
    
  self.Rt4 = host:CreateRenderTarget( 
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_D,
        mathfunction.vector4(self.targetsize2:x(),self.targetsize2:y(),0,0),
        self.targetsize2,
        self.scale2), 
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_D,
        self.targetsize2));

  host:RegisterScriptParameter(self, "bloomMode", mode);
  host:RegisterScriptParameter(self, "bloomcolor", colorselect);   
  host:RegisterScriptParameter(self, "luminance", drag_float_min_max);
  host:RegisterScriptParameter(self, "intensity");
  host:RegisterScriptParameter(self, "radius");

  return self.Queue;
end

function bloom:Resizeview(size)
	self.targetsize = size / 4;
	local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / self.targetsize;

	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
end


function bloom:Process(context, Original, Scene, Output)
	
    self:_Updateparameters()

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
    self.RoLumi:SetParameter(
        self._MainTex,
		    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoLumi);
  context:EndRenderPass();

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();
  

  context:BeginRenderPass(self.Rt3, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassX);
  context:EndRenderPass();
  

  context:BeginRenderPass(self.Rt4, apolloengine.RenderTargetEntity.CF_COLOR);
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoGuassY);
  context:EndRenderPass();


  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
    self.RoCombine:SetParameter(
            apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
            Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    self.RoCombine:SetParameter(
        apolloengine.ShaderEntity.TEXTURE_GLOSSINESS,
        self.Rt4:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.RenderObj, self.RoCombine);
  context:EndRenderPass();
end

function bloom: _Updateparameters()
    local GuassStep = self.step / self.targetsize;
    local combineweight = mathfunction.vector2( 1.0, self.intensity:x());
    self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
    self.RoGuassX:SetParameter( self.SIGMA, mathfunction.vector1( self.radius:x()) );
    self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
    self.RoGuassY:SetParameter( self.SIGMA, mathfunction.vector1( self.radius:x()) );
    self.RoLumi:SetParameter(self.BLOOM_MODE, mathfunction.vector1( self.bloomMode:x()) );
    self.RoLumi:SetParameter(self.BLOOM_COLOR, mathfunction.vector3(self.bloomcolor:x(), self.bloomcolor:y(), self.bloomcolor:z()) );
    self.RoLumi:SetParameter(self.LUMINANCE_THRESHOLD, mathfunction.vector1( self.luminance:x()) );
    self.RoCombine:SetParameter(self.COMBINE_WEIRHT, combineweight );
end

return bloom;