local MemberIterator = require "venuscore.rtti.mpairs"
local apollocore = require "apollocore"

apollocore.IContent.SEP = "=>"

function apollocore.IContent:GetProperties(type_name)
  local res = {}
  local function _MembersIterator(obj, type_name, prefix)
    for key, value in MemberIterator(obj) do
      local fullkey = prefix and prefix .. apollocore.IContent.SEP .. key or key
      if type(value) == type_name then
        table.insert(res, fullkey)
      elseif type(value) == "table" then
        _MembersIterator(value, type_name, fullkey);
      elseif type(value) == "userdata" then
        _MembersIterator(value, type_name, fullkey);
      end
    end  
  end  
  _MembersIterator(self, type_name);
  return res;
end

local function _FindLastObject(obj, keys)
  if next(keys) ~= nil then
    local key = table.remove(keys, 1)
    local data = obj[key];
    if nil ~= data then
      obj = data;
    else      
      key = tonumber(key)
      obj = obj[key];
    end
    if next(keys) ~= nil then
      return _FindLastObject(obj, keys);
    end
  end
  return obj;
end

function apollocore.IContent:GetScriptPropValue(prop)
  --LOG("SUNTYLOG: IContent:GetScriptPropValue: " .. prop)
  local keys = string.split(prop, self.SEP);
  return _FindLastObject(self, keys);
end


function apollocore.IContent:SetScriptPropValue(prop, value)
  local keys = string.split(prop, self.SEP);
  local lastKey = table.remove(keys, #keys);
  local obj = _FindLastObject(self, keys);  
  obj[lastKey] = value
end