//----------------------------------------------------------------------------------------------------
#SHADER_DEFINE CameraspacePosition
   FUNCTION_INPUT =
    {
        { CAMERA_VIEW,                HIGH,    MAT4,        "in_ViewMatrix"},
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
    }
    FUNCTION_OUTPUT =
    {
        { CAMERASPACE_POSITION,       HIGH,    VEC3,      "out_PositionCS"},

    }
#SHADER_CODE
    vec4 position_cameraspace = in_ViewMatrix * vec4(in_Transfrom * in_Position);
    vec3 out_PositionCS = position_cameraspace.xyz / position_cameraspace.w;
#END_CODE
#END_DEFINE


  

//----------------------------------------------------------------------------------------------------
//阴影贴图输出
#SHADER_DEFINE SimpleFragmentOutput

	FUNCTION_INPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" }
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    gl_FragColor = in_SurfaceColor;
#END_CODE
#END_DEFINE

//----------------------------------------------------------------------------------------------------
//计算深度
#SHADER_DEFINE ShadowTransform

	FUNCTION_INPUT = 
	{
    { LIGHT_CAMERA_VIEW,               HIGH, MAT4,   "in_LightCameraViewMatrix"},
    { LIGHT_CAMERA_PROJECTION,         HIGH, MAT4,   "in_LightCameraPorjMatrix"},
    { LIGHT_CAMERA_LINEARPARAM, HIGH,	VEC3,		"in_LightCameraLineDepthParam"},
    { LIGHT_CAMERA_POSITION,    HIGH, VEC3,   "in_LightCameraPosition"},
    { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
    { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
	}

	FUNCTION_OUTPUT = 
	{
    { LIGHTSPACE_COORD,    HIGH, VEC4,    "out_LightCoord"},
    { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "out_OrigDepth"}
	}

#SHADER_CODE
  const mat4 biasMatrix = mat4(0.5,0.0,0.0,0.0,
                        0.0,0.5,0.0,0.0,
                        0.0,0.0,0.5,0.0,
                        0.5,0.5,0.5,1.0);
  vec4 in_PositionWS = (in_Transfrom * in_Position);
  vec4 out_LightCoord = in_LightCameraPorjMatrix * in_LightCameraViewMatrix * in_PositionWS;
  vec4 positionCS = in_LightCameraViewMatrix * in_PositionWS;
  out_LightCoord = out_LightCoord / out_LightCoord.w;
  out_LightCoord = biasMatrix * out_LightCoord;
	highp float out_OrigDepth = ( -positionCS.z / positionCS.w - in_LightCameraLineDepthParam.x ) * in_LightCameraLineDepthParam.y;
  
#END_CODE
#END_DEFINE

//----------------------------------------------------------------------------------------------------
#SHADER_DEFINE DepthMapSamplingLinear

	FUNCTION_INPUT = 
	{
		{ TEXTURE_SHADOW_DEPTH,		NONE,	TEXTURE2D,	"in_DepthMap" },
		{ LIGHTSPACE_COORD,	HIGH,	VEC4,		"in_LightVertexCoordinate" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,				LOW,	VEC4,		"out_DepthVec" },
	}
	
#SHADER_CODE
	lowp vec4 out_DepthVec = texture2D( in_DepthMap, in_LightVertexCoordinate.xy );
#END_CODE
#END_DEFINE

//----------------------------------------------------------------------------------------------------
#SHADER_DEFINE TransparentMapSamplingLinear

	FUNCTION_INPUT = 
	{
		{ LIGHTSPACE_COORD,	HIGH,	VEC4,		"in_LightVertexCoordinate" },
		{ TEXTURE_TRANSPARENT_SHADOW,  NONE, TEXTURE2D, "in_TransparentMap"},
	}

	FUNCTION_OUTPUT = 
	{
		{ SHADOWMAP_COLOR,      HIGH, VEC4,   "out_TransparentColor"},
	}
	
#SHADER_CODE
	highp vec4  out_TransparentColor = texture2D( in_TransparentMap,in_LightVertexCoordinate.xy);
#END_CODE
#END_DEFINE

//----------------------------------------------------------------------------------------------------
//不透明材质的半透明阴影贴图
#SHADER_DEFINE OpaqueShadowFragmentOutput

	FUNCTION_INPUT =  { }
	FUNCTION_OUTPUT = { }

#SHADER_CODE
	gl_FragColor = vec4(1.0,1.0,1.0,0.0);
#END_CODE
#END_DEFINE

//----------------------------------------------------------------------------------------------------
//阴影输出
#SHADER_DEFINE FragmentOutputShadow

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				         MEDIUM,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			         MEDIUM,  VEC3,	  "light_Specular"},
      { LIGHTING_AMBIENT,                   LOW,  VEC3,    "light_Ambient"},
      { DIFFUSE_SCALE,                   MEDIUM, FLOAT,    "diffuseScale" },
      { SPECULAR_SCALE,                  MEDIUM, FLOAT,       "specScale" },
      { WORLDSPACE_DEPTH, 			           HIGH, FLOAT,		  "in_TexDepth" },
		  { WORLDSPACE_LIGHTCAMERA_DISTANCE,   HIGH, FLOAT,     "in_OrigDepth"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
    float constant = 60.0;
    float expFactor = exp(constant * ( in_TexDepth - in_OrigDepth ) );
	  if (expFactor > 1.0)
	  {
		  expFactor = 1.0;
	  }
    
		vec3 color =  expFactor * light_Specular * specScale + expFactor * light_Diffuse * diffuseScale + light_Ambient;
  
		gl_FragColor = vec4(color, 1.0);

#END_CODE
#END_DEFINE

//半透明材质输出半透明阴影贴图
#SHADER_DEFINE FragmentOutputShadowTransparent

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				         MEDIUM,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			         MEDIUM,  VEC3,	  "light_Specular"},
      { LIGHTING_AMBIENT,                   LOW,  VEC3,    "light_Ambient"},
      { DIFFUSE_SCALE,                   MEDIUM, FLOAT,    "diffuseScale" },
      { SPECULAR_SCALE,                  MEDIUM, FLOAT,       "specScale" },
      { WORLDSPACE_DEPTH, 			           HIGH, FLOAT,		  "in_TexDepth" },
		  { WORLDSPACE_LIGHTCAMERA_DISTANCE,   HIGH, FLOAT,     "in_OrigDepth"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
    float constant = 60.0;
    float expFactor = exp(constant * ( in_TexDepth - in_OrigDepth ) );
	  if (expFactor > 1.0)
	  {
		  expFactor = 1.0;
	  }
    
		vec3 color =  expFactor * light_Specular * specScale + expFactor * light_Diffuse * diffuseScale + light_Ambient;
  
		//gl_FragColor = vec4(color, 1.0);
    gl_FragColor =  mix(vec4(vec3(1.0),0.0),vec4(color,0.5),expFactor);
#END_CODE
#END_DEFINE