

#DEFPARAMS
UNIFORM_SCALE_R = { "ScaleR", VEC2, "1.0, 1.0"},
UNIFORM_SCALE_G = { "ScaleG", VEC2, "1.0, 1.0"},
UNIFORM_SCALE_B = { "ScaleB", VEC2, "1.0, 1.0"},
UNIFORM_OFFSET_R = { "OffsetR", VEC2, "0.0, 0.0"},
UNIFORM_OFFSET_G = { "OffsetG", VEC2, "0.0, 0.0"},
UNIFORM_OFFSET_B = { "OffsetB", VEC2, "0.0, 0.0"},
UNIFORM_USE_BORDER = { "UseBorder", VEC2, "1.0, 1.0"},
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "rgbseperate"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
  float2 offsetR : TEXCOORD0;
  float2 offsetG : TEXCOORD1;
  float2 offsetB : TEXCOORD2;
};

Texture2D TEXTURE_SCREEN;
SamplerState TEXTURE_SCREEN_Sampler;
float2 UNIFORM_SCALE_R;
float2 UNIFORM_SCALE_G;
float2 UNIFORM_SCALE_B;
float2 UNIFORM_OFFSET_R;
float2 UNIFORM_OFFSET_G;
float2 UNIFORM_OFFSET_B;
float2 UNIFORM_USE_BORDER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);  

  float2 screenMidPos = (v.uv- 0.5)*2.0;
  float2 out_posR = (screenMidPos.xy - UNIFORM_OFFSET_R / 2.0) / UNIFORM_SCALE_R;
  float2 out_posG = (screenMidPos.xy - UNIFORM_OFFSET_G / 2.0) / UNIFORM_SCALE_G;
  float2 out_posB = (screenMidPos.xy - UNIFORM_OFFSET_B / 2.0) / UNIFORM_SCALE_B;

  o.offsetR = out_posR/2.0 + 0.5;
  o.offsetG = out_posG/2.0 + 0.5;
  o.offsetB = out_posB/2.0 + 0.5;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
  #ifdef POST_EFFECT_ALPHA_OFF
    float4 color;
    float temp;
    float2 vUV_R = i.offsetR;
    float2 vUV_G = i.offsetG;
    float2 vUV_B = i.offsetB;
    temp = TEXTURE_SCREEN.Sample(TEXTURE_SCREEN_Sampler, i.offsetR).r;
    color.r = ((vUV_R.x<0.0||vUV_R.x>1.0)&&UNIFORM_USE_BORDER.x>0.0)||((vUV_R.y<0.0||vUV_R.y>1.0)&&UNIFORM_USE_BORDER.y>0.0)? 0.0: temp;
    temp = TEXTURE_SCREEN.Sample(TEXTURE_SCREEN_Sampler, i.offsetG).g;
    color.g = ((vUV_G.x<0.0||vUV_G.x>1.0)&&UNIFORM_USE_BORDER.x>0.0)||((vUV_G.y<0.0||vUV_G.y>1.0)&&UNIFORM_USE_BORDER.y>0.0)? 0.0: temp;
    temp = TEXTURE_SCREEN.Sample(TEXTURE_SCREEN_Sampler, i.offsetB).b;
    color.b = ((vUV_B.x<0.0||vUV_B.x>1.0)&&UNIFORM_USE_BORDER.x>0.0)||((vUV_B.y<0.0||vUV_B.y>1.0)&&UNIFORM_USE_BORDER.y>0.0)? 0.0: temp;
    color.a = 1.0;
    mainColor = color;
  #elif POST_EFFECT_ALPHA_ON
    float4 color;
    float2 vUV_R = i.offsetR;
    float2 vUV_G = i.offsetG;
    float2 vUV_B = i.offsetB;
    float2 tempRA = TEXTURE_SCREEN.Sample(TEXTURE_SCREEN_Sampler, i.offsetR).ra;
    color.r = ((vUV_R.x<0.0||vUV_R.x>1.0)&&UNIFORM_USE_BORDER.x>0.0)||((vUV_R.y<0.0||vUV_R.y>1.0)&&UNIFORM_USE_BORDER.y>0.0)? 0.0: tempRA.x;
    float2 tempGA = TEXTURE_SCREEN.Sample(TEXTURE_SCREEN_Sampler, i.offsetG).ga;
    color.g = ((vUV_G.x<0.0||vUV_G.x>1.0)&&UNIFORM_USE_BORDER.x>0.0)||((vUV_G.y<0.0||vUV_G.y>1.0)&&UNIFORM_USE_BORDER.y>0.0)? 0.0: tempGA.x;
    float2 tempBA = TEXTURE_SCREEN.Sample(TEXTURE_SCREEN_Sampler, i.offsetB).ba;
    color.b = ((vUV_B.x<0.0||vUV_B.x>1.0)&&UNIFORM_USE_BORDER.x>0.0)||((vUV_B.y<0.0||vUV_B.y>1.0)&&UNIFORM_USE_BORDER.y>0.0)? 0.0: tempBA.x;
    color.a = 1.0 - (1.0-tempRA.y) * (1.0-tempGA.y) * (1.0-tempBA.y);
    mainColor = color;
  #endif
}
ENDCG
#END
