#SHADER_DEFINE TwoMirrorVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_TexCooridate2" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_TexCooridate2 = vec2(1.0-in_TexCooridate.x,in_TexCooridate.y);
#END_CODE
#END_DEFINE

#SHADER_DEFINE TwoMirrorFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"out_TexCooridate"},
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_TexCooridate2" },   
	}
  
#SHADER_CODE
  
   
   vec2 out_Tex = vec2(out_TexCooridate.x+0.25,out_TexCooridate.y);
   vec2 out_Tex2 = vec2(out_TexCooridate2.x+0.25,out_TexCooridate2.y);
   vec3 rgb1 = texture2D(uniCurrentTexture,out_Tex).rgb;
   vec3 rgb2 = texture2D(uniCurrentTexture,out_Tex2).rgb;
   vec3 dstrgb = step(0.5,out_TexCooridate.x)*rgb2 + (1.0-step(0.5,out_TexCooridate.x))*rgb1;
   gl_FragColor = vec4(dstrgb,1.0);

#END_CODE
#END_DEFINE