

#DEFPARAMS
	_Color = {"_Color", COLOR, "1.0,1.0,1.0,1.0"},
	_MainTex = {"_MainTex", TEXTURE2D, "black"},
	_MaskMap = {"_MaskMap", TEXTURE2D, "white"},
	_LipMaskMap = {"_LipMaskMap", TEXTURE2D, "white"},
	_DetailMainTex = {"_DetailMainTex", TEXTURE2D, "white"},
	_DetailMainTex_ST = {"_DetailMainTex_ST", VEC4, "1.00, 1.00, 0.00, 0.00"},
	_DetailMask = {"_DetailMask", TEXTURE2D, "white"},

	_NormalMap = {"_NormalMap", TEXTURE2D, "bump"},
	_NormalScale = {"_NormalScale", FLOAT, "1.00"},
	_DetailNormalMap = {"_DetailNormalMap", TEXTURE2D, "bump"},
	_DetailNormalMap_ST = {"_DetailNormalMap_ST", VEC4, "1.00, 1.00, 0.00, 0.00"},
	_DetailNormalMapScale = {"_DetailNormalMap_Scale", FLOAT, "0.20"},

	_MetallicRoughnessMap = {"_MetallicRoughnessMap", TEXTURE2D, "white"},
	_MetallicRoughness = {"MetallicRoughness", VEC2, "0.80, 0.10"},
	_DetailMRMap = {"_DetailMRMap", TEXTURE2D, "white"},

	_EnvTex = {"_EnvTex", TEXTURE2D, "black"},
	_EnvRotation_X = {"_EnvRotation_X", FLOATRANGE, "0.0, 1.0, 0.0" },
	_EnvRotation_Y = {"_EnvRotation_Y", FLOATRANGE, "0.0, 1.0, 0.0" },
	_EnvExposure = {"_EnvExposure", FLOAT, "1.00"},
	_EnvTex_ST = {"_EnvTex_ST", VEC4, "1.00, 1.00, 0.00, 0.00"},
	_HDRSpecCube = {"_HDRSpecCube", TEXTURECUBE, "black"},
	_HDRRotation_X = {"_HDRRotation_X", FLOATRANGE, "0.0, 360.0, 0.0" },
	_HDRRotation_Y = {"_HDRRotation_Y", FLOATRANGE, "0.0, 360.0, 0.0" },
	_LightDiffStrength = {"_LightDiffStrength", FLOAT, "1.00"},
	_LightSpecStrength = {"_LightSpecStrength", FLOAT, "1.00"},
	_HDRSpecStrength = {"_HDRSpecStrength", FLOAT, "1.00"},
	_Anisotropy = {"_Anisotropy", FLOAT, "0.781"},
	_Tanoff = {"_Tanoff", FLOAT, "0.31"},

	_EditorMaskMap = {"EditorMaskTex", TEXTURE2D, "white" },
	_LutMap = {"Lut Map", TEXTURE2D, "white" },
	_MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
	_MaskScaleInfo = {"MaskScaleInfo",VEC4,"0.0,0.0,0.0,0.0"},
	_Opacity = { "Opacity", FLOATRANGE, "0.5, 4.0, 0" }, 
	_BacklightDecay = { "Backlight decay", FLOAT, "1.0" },
	_Reflection = { "Relfection Intensity", FLOATRANGE, "4.0, 10.0, 0.0" },
	_Backlight = {"Backlight",VEC3,"0.0,0.0,0.0"},
	_Frontlight = {"Frontlight",VEC3,"1.0,1.0,1.0"},
	_Strength = { "BlendStrength", FLOAT, "1.0" },
	_UseBacklight = {"Use Backlight", FLOAT, "0.0"},
	_UseFrontlight = {"Use Frontlight", FLOAT, "0.0"},
	[Enum(BlendFactor)]
	_BlendSrc = {"Blend Src", FLOAT, "1.0"},
	[Enum(BlendFactor)]
	_BlendDst = {"Blend Dst", FLOAT, "0.0"},
	[Enum(PolygonMode)]
	_Polygon = {"Polygon Mode", FLOAT, "2.0"},
	[Keywords(BLEND_NORMAL, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_OVERLAY, BLEND_COLORBURN, BLEND_LINEARBURN, BLEND_COLORDODGE, BLEND_LINEARDODGE, BLEND_Hue, BLEND_SATURATION, BLEND_LUMINOSITY, BLEND_COLOR, BLEND_BLEND, BLEND_EXCLUSION, BLEND_HARDLIGHT, BLEND_VIVIDLIGHT, BLEND_SOFTLIGHT, BLEND_HARDMIX, BLEND_PINLIGHT, BLEND_LINEARLIGHT, BLEND_DIFF, BLEND_SUB, BLEND_LUT)]
	_BlendMode = {"Blend Mode", FLOAT, "1.0"},
	[Keywords(FULL_EFFECT, DEBUG_NORMAL, DEBUG_SPECCOEFF, DEBUG_IBL, DEBUG_HDRSPECULAR)]
	DEBUGMODE = {"DEBUGMODE", FLOAT, "0.0"},
	[Keywords(IBLSPEC_OFF, IBLSPEC_ON)]
	IBLSpecEnable = {"A_IBL Spec Enable", FLOAT, "1.0"},
	[Keywords(LIGHTSPEC_OFF, LIGHTSPEC_ON)]
	LightSpecEnable = {"A_Light Spec Enable", FLOAT, "1.0"},
	[Keywords(HDRSPEC_OFF, HDRSPEC_ON)]
	HDRSpecEnable = {"A_HDR Spec Enable", FLOAT, "1.0"},
	[Keywords(ANISOTROPY_OFF, ANISOTROPY_ON)]
	AnisotropyEnable = {"ANISOTROPY Enable", FLOAT, "0.0"},
	[Keywords(TONEMAPPING_OFF, TONEMAPPING_ON)]
	TonemappingEnable = {"TONEMAPPING Enable", FLOAT, "0.0"},
	_DefMode = { "def Mode", FLOAT, "2.0"},
	_UseMask = { "Mask On", FLOAT, "0.0"},
	_UseBvtMask = {"BvtMask On",FLOAT,"0.0"},
	_VideoSize = {"Video Size",VEC2,"0.0,0.0"},
	_MaskInfoBvt = {"_MaskInfoBvt",VEC4,"0.0,0.0,0.0,0.0"},
	_Flip = { "Flip", VEC2, "0.0,0.0" },
	_LipTangent = {"_LipTangent",VEC3,"1.0,0.0,0.0"},
	_LipBitangent = {"_Bitangent",VEC3,"0.0,1.0,0.0"},
	_LipNormal = {"_LipNormal",VEC3,"0.0,0.0,1.0"},
	_LipDeformNormal = {"_LipDeformNormal",VEC3,"0.0,0.0,1.0"},
	_LipStrengthMask = {"_LipStrengthMask", TEXTURE2D, "white"},

	_HDRSpecCube_HDR = {"_HDRSpecCube_HDR", VEC4, "4.59479, 1.00, 0.0, 0.0"},
	_SHAr = {"_SHAr", VEC4, "-0.04214, 0.06453, 0.3197, 0.23602"},
	_SHAg = {"_SHAg", VEC4, "-0.04629, 0.0731, 0.32658, 0.2172"},
	_SHAb = {"_SHAb", VEC4, "-0.05133, 0.08127, 0.3611, 0.22084"},
	_SHBr = {"_SHBr", VEC4, "0.00539, 0.14481, 0.17529, -0.02462"},
	_SHBg = {"_SHBg", VEC4, "-0.00098, 0.14891, 0.17741, -0.03435"},
	_SHBb = {"_SHBb", VEC4, "-0.00732, 0.16732, 0.1921, -0.04204"},
	_SHC = {"_SHC", VEC4, "0.01316, 0.01409, 0.01303, 1.00"},

	VIRTUALCAMERAPOS = {"VIRTUALCAMERAPOS", VEC4, "0.5, 0.5, 1.0, 1.0"},
	_LightIntensity = {"_LightIntensity", FLOAT, "1.0"},
	_LightColor = {"_LightColor", COLOR, "1.0, 1.0, 1.0, 1.0"},
	_LightDir = {"_LightDir", VEC4, "0.0, -0.3, -1.0, 0.0"}
#END

#DEFTAG
	ShaderName = "makeup"
	RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }
POLYGON_MODE = { "%_Polygon" }
POINT_SIZE = 5


CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fbfetch
#include "common.inc"
#include "blendfunc_plenty.inc"
// #include "tonemappingACES.inc"
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY
#pragma multi_compile FULL_EFFECT DEBUG_NORMAL DEBUG_SPECCOEFF DEBUG_IBL DEBUG_HDRSPECULAR
#pragma multi_compile HDRSPEC_OFF HDRSPEC_ON
#pragma multi_compile LIGHTSPEC_OFF LIGHTSPEC_ON
#pragma multi_compile IBLSPEC_OFF IBLSPEC_ON


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	float4 screenPos : TEXCOORD1;
	float reliability: TEXCOORD2;
	float2 maskuv : TEXCOORD3;
	float isEditor : TEXCOORD4;
	float4 detailUV : TEXCOORD5;
	float3 worldPos : TEXCOORD6;
	float3 negative_V : TEXCOORD7;
	float4 SH : TEXCOORD8;
	FRAMEBUFFER_COLOR_ATTRIBUTE
};

// Parameter
	float _UseMask;
	Texture2D _MaskMap;
	Texture2D _LipMaskMap;
	Texture2D _EditorMaskMap;
	SamplerState _MaskSampler;
	SamplerState _LipMaskMapSampler;
	SamplerState _NormalMapSampler;
	SamplerState _EditorMaskSampler;
	float4 _MaskScaleInfo;

	Texture2D _NormalMap;
	Texture2D _DetailNormalMap;
	Texture2D _MetallicRoughnessMap;
	Texture2D _DetailMRMap;
	Texture2D _MainTex;
	Texture2D _EnvTex;
	Texture2D _LipStrengthMask;
	Texture2D _DetailMask;
	Texture2D _DetailMainTex;
	Texture2D _LutMap;
	TextureCube _HDRSpecCube;

	SamplerState _DetailNormalSampler;
	SamplerState _MetallicRoughnessSampler;
	SamplerState _DetailMRSampler;
	SamplerState _MainSampler;
	SamplerState _EnvSampler;
	SamplerState _LipStrengthMaskSampler;
	SamplerState _DetailMaskSampler;
	SamplerState _DetailAlbedoSampler;
	SamplerState _LutSampler;
	SamplerState _HDRSpecCube_SAMPLER;

	float4 _Color;
	float4 _MaskInfo;
	float _DefMode;
	float _UseBvtMask;
	float2 _VideoSize;
	float4 _MaskInfoBvt;
	float2 _Flip;
	float4 _DetailNormalMap_ST;
	float4 _DetailMainTex_ST;

	float _UseBacklight;
	float _UseFrontlight;
	float _BacklightDecay;
	float _Reflection;
	float3 _Backlight;
	float3 _Frontlight;
	float _Opacity;
	float _Strength;
	float _NormalScale;
	float _DetailNormalMapScale;

	float3 _LipTangent;
	float3 _LipBitangent;
	float3 _LipNormal;
	float3 _LipDeformNormal;

	float2 _MetallicRoughness;
	float _EnvRotation_X;
	float _EnvRotation_Y;
	float _EnvExposure;
	float _HDRRotation_X;
	float _HDRRotation_Y;
	float _LightDiffStrength;
	float _LightSpecStrength;
	float _HDRSpecStrength;
	float _Anisotropy;
	float _Tanoff;
  float TonemappingEnable;
	float4 _EnvTex_ST;

	float4 _HDRSpecCube_HDR;
	float4 _SHAr;
	float4 _SHAg;
	float4 _SHAb;
	float4 _SHBr;
	float4 _SHBg;
	float4 _SHBb;
	float4 _SHC;

	uniform float4 VIRTUALCAMERAPOS;
	// uniform float4 LIGHTCOLOR[4];
	// uniform float4 LIGHTDIR[4];
  uniform float _LightIntensity;
	uniform float4 _LightColor;
	uniform float4 _LightDir;
	uniform float LIGHTCOUNT;

#define PI 3.14159265359

v2f vert(appdata v)
{
	v2f o = (v2f)0;

	float uOffset = (v.uv.x * 1000.0 - _MaskInfo.x) / _MaskInfo.z;
	float vOffset = (v.uv.y * 1500.0 - _MaskInfo.y) / _MaskInfo.w;
	float2 uv_offset = float2(uOffset, vOffset);
	o.uv = uv_offset;
	float sceneType = v.vertex.w;
	float4 pos;
	if(sceneType > 0.1)
	{
		float scene2DRectWidth = 0.2;
		float scene2DRectHeight = 0.3;
		float xCenter = 0.1/scene2DRectWidth;
		float yCenter = 1.0 - 0.12/scene2DRectHeight;
		float2 uv2pos;
		uv2pos.x = (v.uv.x - xCenter) * scene2DRectWidth;
		uv2pos.y = ( v.uv.y - yCenter) * scene2DRectHeight;
		pos = float4(uv2pos.x, -uv2pos.y, 0.0,1.0);
		pos = ObjectToClipPos(pos);
		o.worldPos.xyz = pos.xyz;
		o.screenPos = ComputeScreenPos(pos);
		o.reliability = 1.0;
		if(_UseMask > 0.1)
		{
			o.maskuv = float2(v.uv.x*1000.0 - _MaskScaleInfo.x, v.uv.y*1500.0 - _MaskScaleInfo.y) / float2(_MaskScaleInfo.z, _MaskScaleInfo.w);
		}
	}
	else
	{
		o.reliability = v.vertex.z;
		pos = float4(v.vertex.x,v.vertex.y,0.0,1.0);
		pos = ObjectToWorldPos(pos);
		o.worldPos.xyz = pos.xyz;
		o.screenPos = ComputeScreenPos(pos);
		if(_UseMask > 0.1)
		{
			o.maskuv = o.screenPos.xy / o.screenPos.w;
		}
		else if(_UseBvtMask > 0.1)
		{
			float2 tempuv = (v.vertex.xy + 1.0)/2.0;
			float2 rangUvX = float2(_MaskInfoBvt.x,_MaskInfoBvt.x + _MaskInfoBvt.z)/_VideoSize.x;
			float2 rangUvY = float2(_VideoSize.y-_MaskInfoBvt.y-_MaskInfoBvt.w, _VideoSize.y-_MaskInfoBvt.y)/_VideoSize.y;
			o.maskuv = float2((tempuv.x - rangUvX.x)/(rangUvX.y - rangUvX.x),1.0 - (tempuv.y - rangUvY.x)/(rangUvY.y - rangUvY.x));
		}
	}

	o.uv = _Flip + (float2(1.0, 1.0) - float2(2.0, 2.0) * _Flip) * o.uv;
	o.detailUV.xy = v.uv * _DetailMainTex_ST.xy + _DetailMainTex_ST.zw;
	o.detailUV.zw = v.uv * _DetailNormalMap_ST.xy + _DetailNormalMap_ST.zw;
	// VIRTUALCAMERAPOS.w 是给 VIRTUALCAMERAPOS.z的补充；negative_V 由相机指向绘制点
	// o.negative_V.xy = (o.screenPos.xy + (-VIRTUALCAMERAPOS.xy))*VIRTUALCAMERAPOS.w;
	o.negative_V.xy = (o.screenPos.xy + (-VIRTUALCAMERAPOS.xy));
	o.negative_V.z = -(VIRTUALCAMERAPOS.z + VIRTUALCAMERAPOS.w);

	float3 shnormal = _LipNormal;
	shnormal.x = -shnormal.x;
	float sh = shnormal.x * shnormal.x - shnormal.y * shnormal.y;
	float4 sh_dir = shnormal.yzzx * shnormal.xyzz;
	float3 res;
	res.x = dot(_SHBr, sh_dir);
	res.y = dot(_SHBg, sh_dir);
	res.z = dot(_SHBb, sh_dir);
	o.SH.xyz = _SHC.xyz * sh.xxx + res.xyz;
	o.SH.w = 0.0;
	o.vertex = UniformNDC(pos);
	return o;
}

float4 GetSourceColor(v2f i, float4 fbColor)
{
#if FRAMEBUFFER_FETCH 
	return fbColor; 
#else
	float2 uvCoord = i.screenPos.xy / i.screenPos.w;
	float4 srcColor = TEXTURE_GRAP.Sample(TEXTURE_GRAP_Sampler, uvCoord);
	return srcColor;
#endif
}

float CalBrightnessFactor(float3 color, float k) 
{
	float brightness = (color.r + color.g + color.b) * 0.3333333333;
	float b = clamp(brightness * k, 0.2, 1.0);
	return b;
}

float3 RotateAroundYInDegrees (float3 vertex, float degrees)
{
	float alpha = degrees * PI / 180.0;
	float sina, cosa;
	sincos(alpha, sina, cosa);
	float2x2 m = float2x2(cosa, -sina, sina, cosa);
	return float3(mul(m, vertex.xz), vertex.y).xzy;
}

float3 RotateAroundXInDegrees (float3 vertex, float degrees)
{
	float alpha = degrees * PI / 180.0;
	float sina, cosa;
	sincos(alpha, sina, cosa);
	float2x2 m = float2x2(cosa, sina, sina, cosa);
	return float3(mul(m, vertex.yz), vertex.x).zxy;
}

float3 SampleSpecCube(TextureCube _HDRSpecCube, SamplerState _HDRSpecCube_SAMPLER, float4 worldNormal, float3 negative_V, float R, float Xrotation, float Yrotation)
{
	float3 reflectV;
	reflectV.x = dot(negative_V, worldNormal.xyz) * 2;
	reflectV.xyz = worldNormal.xyz * (-reflectV.xxx) + negative_V;
	reflectV.x = -reflectV.x;
	reflectV.y = -reflectV.y;
  float3 dir = RotateAroundXInDegrees(reflectV, Xrotation);
  dir = RotateAroundYInDegrees(dir, Yrotation);
	float4 SpecCube = _HDRSpecCube.SampleLevel(_HDRSpecCube_SAMPLER, dir, 6.0*R*(1.7-R*0.7));
	// rgbm解码
	float s = _HDRSpecCube_HDR.w * (SpecCube.w-1.0) + 1.0;
	s = pow(s, _HDRSpecCube_HDR.y) * _HDRSpecCube_HDR.x;
	float3 Specular = SpecCube.xyz * s.xxx;
	return Specular;
}

float CalculateAttenation(float3 LP, float3 P, float invrange)
{
	float3 lightCoord = (P - LP) * invrange;
	float atten = LIGHTTEXTURE0.Sample(LIGHTTEXTURE0Sampler, dot(lightCoord, lightCoord).xx).x;
	return atten;
}

void CalculateAnisotropy(out float3 SpecCoeff, float3 firLight, float4 worldNormal, float3 worldTangent, float3 worldBiTangent, float3 negative_V, float3 lightColor, float _Tanoff, float _LightSpecStrength, float R,  float shadow)
{
	float3 modifiedTangent = normalize(worldBiTangent.xyz * _Tanoff + worldTangent.xyz);
	float3 modifiedBiTangent = normalize(cross(worldNormal.xyz, modifiedTangent.xyz));

	float3 V_L = (-negative_V).xyz + firLight.xyz;
	float anisotropyL = 1.0 - _Anisotropy;
	float anisotropyR = 1.0 + _Anisotropy;

	// 计算各向异性部分
		float R2 = R * R;
		float R4 = R2 * R2;
		float aniR_R2 = anisotropyR * R2;
		float aniL_R2 = anisotropyL * R2;
		float nevR4 = 1.0 / (R2 * R2 + 1.0);
		float d_T_V = dot(modifiedTangent, -negative_V);
		float d_BT_V = dot(modifiedBiTangent, -negative_V);
		float d_N_V = dot(worldNormal.xyz, -negative_V);

		float3 AnisotropyCoeffV;
		AnisotropyCoeffV.x = d_T_V * aniR_R2;
		AnisotropyCoeffV.y = d_BT_V * aniL_R2;
		AnisotropyCoeffV.z = max(d_N_V, 9.99999975e-05);

		float d_T_L = dot(modifiedTangent, firLight.xyz);
		float d_BT_L = dot(modifiedTangent, firLight.xyz);
		float d_N_L = dot(worldNormal.xyz, firLight.xyz);

		float3 AnisotropyCoeffL;
		AnisotropyCoeffL.x = d_T_L * aniR_R2;
		AnisotropyCoeffL.y = d_BT_L * aniL_R2;
		AnisotropyCoeffL.z = clamp(d_N_L, 0.0, 1.0);

		float3 h_L_V = firLight.xyz - negative_V; 
		float d_L_V = dot(firLight.xyz, -negative_V);

		float tmp1 = max(d_L_V * 2.0 + 2.0, 5.96046448e-08);
		tmp1 = 1.0 / sqrt(tmp1);

		float d_T_H = dot(modifiedTangent, h_L_V * tmp1);
		float d_BT_H = dot(modifiedBiTangent, h_L_V * tmp1);
		float tmp2 = aniR_R2 * aniL_R2;

		float3 AnisotropyCoeffH;
		AnisotropyCoeffH.x = aniL_R2 * d_T_H;
		AnisotropyCoeffH.y = aniR_R2 * d_BT_H;
		AnisotropyCoeffH.z = tmp2 * clamp((AnisotropyCoeffL.z + d_N_V) * tmp1, 0.0, 1.0);

		float dualCosLV = 1.0-clamp(tmp1* d_L_V + tmp1, 0.0, 1.0);

		// finalAniso
		float aniso = length(AnisotropyCoeffL) * AnisotropyCoeffV.z + length(AnisotropyCoeffV) * AnisotropyCoeffL.z;
		float aniosdot = dot(AnisotropyCoeffH, AnisotropyCoeffH);
		float anisoDenominator = max(aniosdot * aniosdot * aniso, 1.17549435e-6) * 1000.0;
		float aniosNominator = pow(tmp2 * 10, 3) * 0.159154937;

		float SpecCoeff_v1 = aniosNominator / anisoDenominator * 3.14159274 * AnisotropyCoeffL.z;
		SpecCoeff = clamp(SpecCoeff_v1, 0.0, 100.0) * shadow * lightColor.xyz * _LightSpecStrength;
}

float3 CalculateSHResult(float3 iSH, float4 finalN, float4 SHAr, float4 SHAg, float4 SHAb, float OA)
{
	float4 shnormal = finalN;
	float3 shcolor = float3(0.0, 0.0, 0.0);
	shnormal.x = -shnormal.x;
	shcolor.x = dot(SHAr, shnormal);
	shcolor.y = dot(SHAg, shnormal);
	shcolor.z = dot(SHAb, shnormal);
	shcolor.xyz = max(shcolor.xyz + iSH.xyz, float3(0.0, 0.0, 0.0));
	shcolor = shcolor * OA;
	return shcolor;
}

float2 DirToPanoramicTexCoords(float3 reflDir, float rotationX, float rotationY)
{
		float2 uv;
		uv.x = atan2(reflDir.x, -reflDir.z) - PI / 2.0;
		uv.y = acos(reflDir.y);
		uv = uv / float2(2.0 * PI, PI);
		uv.x += rotationX;
		uv.y += rotationY;
		uv.x = frac(uv.x + floor(uv.x) + 1.0);
		uv.y = frac(uv.y + floor(uv.y) + 1.0);
		return uv;
}

float3 IBLShading(float3 normal, float3 negative_V, float rotationX, float rotationY, float4 _EnvTex_ST, Texture2D _EnvTex, SamplerState _EnvSampler)
{
		float3 reflectDir = normalize(reflect(negative_V, normal));
		float2 uv = DirToPanoramicTexCoords(reflectDir, rotationX, rotationY);
		float3 radiance = _EnvTex.Sample(_EnvSampler, uv * _EnvTex_ST.xy + _EnvTex_ST.zw).rgb;
		return radiance;
}

float3 ACESFilm(float3 x)
{
		float a = 2.51f;
		float b = 0.03f;
		float c = 2.43f;
		float d = 0.59f;
		float e = 0.14f;
		return saturate((x*(a*x+b))/(x*(c*x+d)+e));
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
		float OA = 1.0;
		float3 outColor = float3(0.0, 0.0, 0.0);
		float3 negative_V = normalize(i.negative_V.xyz);
		float3 HDRsamplerV = normalize(float3(i.negative_V.xy, i.negative_V.z + VIRTUALCAMERAPOS.w).xyz);

	// 基础贴图采样
		float4 materialColor = _MainTex.Sample(_MainSampler, i.uv);
		float4 DetailAlbedo = _DetailMainTex.Sample(_DetailAlbedoSampler, i.uv);
		float DetailMask = _DetailMask.Sample(_DetailMaskSampler, i.uv).w;
		float LipStrength = _LipStrengthMask.Sample(_LipStrengthMaskSampler, i.uv).r;

	// 计算法线混合
		float3 DetailNormal = _DetailNormalMap.Sample(_DetailNormalSampler, i.detailUV.zw).xyz;
		DetailNormal = DetailNormal * 2.0 - 1.0;
		float3 Bump = _NormalMap.Sample(_NormalMapSampler, i.uv).xyz;
		Bump = Bump * 2.0 - 1.0;
		Bump.xy = Bump.xy * _NormalScale;
		float4 worldNormal;
		worldNormal.xy = DetailNormal.xy * _DetailNormalMapScale + Bump.xy;
		worldNormal.z = DetailNormal.z + Bump.z;
		worldNormal.xyz = normalize(worldNormal.x * _LipTangent.xyz + worldNormal.y * _LipBitangent.xyz + worldNormal.z * _LipNormal.xyz);
		worldNormal.w = 1.0;
		// 追加唇部变形的法线影响
		float LipMask = _LipMaskMap.Sample(_LipMaskMapSampler, i.uv).x;
		worldNormal.xyz = normalize(worldNormal.x * _LipTangent.xyz + worldNormal.y * _LipBitangent.xyz + worldNormal.z * float3(_LipDeformNormal.x, _LipDeformNormal.y * (LipMask > 0.5 ? -1.0 : 1.0), _LipDeformNormal.z));
		float3 worldTangent = normalize(_LipTangent.xyz);
		float3 worldBiTangent = normalize(cross(worldNormal.xyz, worldTangent.xyz));

	// 计算金属度、粗糙度
		float4 DetailMR = _DetailMRMap.Sample(_DetailMRSampler, i.detailUV.xy);
		float3 MetallicRoughness = _MetallicRoughnessMap.Sample(_MetallicRoughnessSampler, i.uv).xyz;
		float2 MR = MetallicRoughness.xy * _MetallicRoughness.xy;
		float2 RM = MR.yx;
		RM.x = 1.0 - clamp(RM.x, 0.0, 1.0);
		float R = max(1.0 - RM.x, 0.01);
		float R2 = R * R;
		float R4 = R2 * R2;
		float metal = min(RM.y, 1.0);

	// 计算baseColor
		float3 baseColor = materialColor.xyz * _Color.xyz;
		float3 deltaColor = baseColor * DetailAlbedo.xyz + (-baseColor);
		baseColor = DetailMask * deltaColor + baseColor;
		float3 F0 = float3(metal,metal,metal) * (baseColor - float3(0.04,0.04,0.04)) + float3(0.04,0.04,0.04);
		baseColor = (0.96-metal*0.96) * baseColor;
		float baseF0 = clamp(0.04 + metal*0.96 + RM.x, 0.0, 1.0);
		float cosNV = dot(worldNormal.xyz, -negative_V);
		float posiCosNV = max(cosNV, 9.99999975e-05);

		// 1.基础SH光照，加SpecCube环境光
			// 计算SH
			float3 SH = float3(0.0, 0.0, 0.0);
			float3 pureSpecular = float3(0.0, 0.0, 0.0);
			#if HDRSPEC_ON
				SH = CalculateSHResult(i.SH.xyz, worldNormal, _SHAr, _SHAg, _SHAb, OA);

				// 采样 _HDRSpecCube
				float3 Specular = SampleSpecCube(_HDRSpecCube, _HDRSpecCube_SAMPLER, worldNormal, HDRsamplerV, R, _HDRRotation_X, _HDRRotation_Y);
				pureSpecular = Specular;
				Specular = Specular * OA;
				Specular = Specular * 1.0 / (R4 + 1.0);
				float dualCosNV = (-posiCosNV) + 1.0;
				float dualCosNV5 = dualCosNV * dualCosNV * dualCosNV *dualCosNV * dualCosNV;
				float3 deltaF0 = (-F0) + float3(baseF0, baseF0, baseF0);
				deltaF0 = dualCosNV5 * deltaF0 + F0;
				Specular = Specular * deltaF0;

				// 基础颜色加SH光照，加SpecCube环境光
				outColor += (baseColor * SH + Specular * _HDRSpecStrength);
			#endif

		// 2.遍历处理灯光数据，执行光照并按alpha累加
			float3 SpecCoeff = float3(0.0, 0.0, 0.0);

			// 简化灯光赋值
				float3 lightDir = float3(0.0, 0.0, 0.0);
				lightDir = normalize(-_LightDir.xyz);
				float lightatt = 1.0;
				float3 lightColor = _LightColor.xyz;
				lightColor = lightColor * lightatt * _LightIntensity;

			// Shadow map
				float shadowatt = 1.0;

			// lightDir 夹角
				float cosNL = clamp(dot(worldNormal.xyz, lightDir.xyz), 0.0, 1.0);
				float cosLV = dot(lightDir.xyz, -negative_V);
				float tmp1 = max(cosLV * 2.0 + 2.0, 5.96046448e-08);
				tmp1 = 1.0 / sqrt(tmp1);
				float dualCosLV = 1.0 - clamp(tmp1 * cosLV + tmp1, 0.0, 1.0);

			// 计算灯光diffuse部分
				float3 lightDiff = baseColor * lightColor.xyz * shadowatt * cosNL * _LightDiffStrength;
				outColor += lightDiff;
			#if LIGHTSPEC_ON
				// 计算高光系数，是否各向异性
					// #if ANISOTROPY_OFF
						float tmp0 = cosNL * cosNL * (1 - R4) + R4;
						tmp0 = posiCosNV * sqrt(tmp0);
						float tmp2 = posiCosNV * posiCosNV * (1 - R4) + R4;
						tmp2 = cosNL * sqrt(tmp2) + tmp0;
						float cosNVL = clamp((cosNV + cosNL) * tmp1, 0.0, 1.0);
						float SpecCoeff_v1 = cosNVL * cosNVL * (R4 - 1) + 1.0;
						SpecCoeff_v1 = tmp2 * SpecCoeff_v1 * SpecCoeff_v1;
						SpecCoeff_v1 = cosNL * R4 * 0.159154937 * 3.14159274 / max(SpecCoeff_v1, 1.17549435e-6);
						SpecCoeff = min(SpecCoeff_v1, 100.0) * lightColor.xyz * shadowatt * _LightSpecStrength;
					// #elif ANISOTROPY_ON
					// 	CalculateAnisotropy(SpecCoeff, lightDir, worldNormal, worldTangent, worldBiTangent, negative_V, lightColor, _Tanoff, _LightSpecStrength, R, shadowatt);
					// #endif

				// 计算灯光specular部分
					float dualCosLV5 = dualCosLV * dualCosLV * dualCosLV * dualCosLV * dualCosLV;
					float3 F = (float3(1.0,1.0,1.0)-F0) * dualCosLV5.xxx + F0;
					// SpecCoeff = ColorGradeHDR(SpecCoeff.xyz);
					float3 lightSpec = SpecCoeff * F;
					// Tonemapping 修正过曝高光
					if (TonemappingEnable > 0.5)
						lightSpec = ACESFilm(lightSpec);
					outColor += lightSpec * LipStrength;
			#endif

		// 3.计算IBL部分
		float3 IBLColor = float3(0.0, 0.0, 0.0);
		#if IBLSPEC_ON
			IBLColor = IBLShading(worldNormal.xyz, negative_V.xyz, _EnvRotation_X, _EnvRotation_Y, _EnvTex_ST, _EnvTex, _EnvSampler);
			outColor += IBLColor * _EnvExposure * LipStrength;
		#endif

	// uv越界后alpha=1
		float alphaValue = 0.0;
		if(i.uv.x>0.0&&i.uv.x<1.0&&i.uv.y>0.0&&i.uv.y<1.0) 
		{
			alphaValue = 1.0;
		}

	// sample the texture
	// 光照计算完毕，放到blendColor
		float factor = 1.0;
		factor = materialColor.a * _Strength * i.reliability * alphaValue * _Opacity;
		// float3 blendColor = materialColor.rgb;
		// 拿到光照结果，执行混合

		float3 blendColor = outColor.rgb;
		// #if SPECBLEND_ON // spec 也参与混合计算
		// 	float3 blendColor = outColor.rgb;
		// #elif SPECBLEND_OFF // spec 在materialColor混合计算后单独加上（认为比materialColor原始采样结果高的为spec）
		// 	float3 blendColor = materialColor.rgb;
		// #endif

	if(_UseMask > 0.1)
	{
		if(i.isEditor > 0.1)
		{
			factor *= (_EditorMaskMap.Sample(_EditorMaskSampler, i.maskuv)).r;
		}
		else
		{
			factor *= (_MaskMap.Sample(_MaskSampler, i.maskuv)).r;
		}
	}
	else if(_UseBvtMask > 0.1)
	{
		float bvtMaskColorAlpha = _MaskMap.Sample(_MaskSampler, i.maskuv).a;
		if(i.maskuv.x < 0.0 || i.maskuv.y < 0.0 || i.maskuv.x > 1.0 || i.maskuv.y > 1.0)
			bvtMaskColorAlpha = 0.0;
		factor = bvtMaskColorAlpha>0.0?(factor *(1.0 - bvtMaskColorAlpha)):factor;
	}

	float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);

	#if FRAMEBUFFER_FETCH
		#if SHADER_API_GLES || SHADER_API_GLES3
			float4 fbc = FramebufferFetchES2();
		#elif SHADER_API_METAL
			float4 fbc = i.fbcInternal;
		#else
			float4 fbc = float4(0.0, 0.0, 0.0, 0.0);
		#endif
	#else
		float4 fbc = resultColor;
	#endif

	float3 backlight = _Backlight * _BacklightDecay * _UseBacklight;
	bool use_frontlight = _UseFrontlight > 0.5;

	#if BLEND_NORMAL
		if (use_frontlight) {
			blendColor *= CalBrightnessFactor(_Frontlight, _Reflection);
		}

		float3 colormain = GetSourceColor(i, fbc).rgb;
		float3 faceColor = colormain - backlight;
		blendColor += backlight;

		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
	#elif BLEND_MULTIPLY
		// float3 whiteColor = float3(1.0, 1.0, 1.0);
		// blendColor = whiteColor - factor * (whiteColor - blendColor);

		// float3 colormain = GetSourceColor(i, fbc).rgb;
		// colormain = max(colormain, float3(0.0001, 0.0001, 0.0001));
		// float3 faceColor = colormain - backlight;
		// blendColor = (faceColor * blendColor + backlight) / colormain;

		// resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);

		float4 srcColor = GetSourceColor(i, fbc);
		blendColor = srcColor.rgb - factor * (srcColor.rgb - blendColor * srcColor.rgb);
		resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
	#endif

	// mainColor = resultColor;
	#if FULL_EFFECT 
		mainColor = resultColor;
		// #if SPECBLEND_OFF
		// 	if (outColor.x > materialColor.x && outColor.y > materialColor.y && outColor.z > materialColor.z)
		// 	{
		// 		mainColor.xyz += (outColor.xyz - materialColor.xyz) * factor;
		// 	}
		// #endif
	#elif DEBUG_NORMAL
		mainColor.xyz = worldNormal.xyz;
		mainColor.w = 1.0;
	#elif DEBUG_SPECCOEFF
		mainColor.xyz = SpecCoeff.xyz;
		mainColor.w = 1.0;
	#elif DEBUG_IBL
		mainColor.xyz = IBLColor.xyz;
		mainColor.w = 1.0;
	#elif DEBUG_HDRSPECULAR
		mainColor.xyz = pureSpecular.xyz;
		mainColor.w = 1.0;
	#endif


}
ENDCG
#END
