

#DEFPARAMS
_EnvMap = { "Env Map", TEXTURECUBE, "cube"},
_BumpMap = { "Normal Map", TEXTURE2D, "bump" },
_LodLevel = { "cube Mip Level", FLOAT, "3.0"},
#END

#DEFTAG
ShaderName = "CubeTest"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
};

Texture2D _BumpMap;
SamplerState _BumpMapSampler;
TextureCube _EnvMap;
SamplerState _EnvMapSampler;
float _LodLevel;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	// normal world
	float2 bumpUV = i.uv;
	float3 normalTangent = _BumpMap.Sample(_BumpMapSampler, bumpUV).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	// reflect dir
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 reflectDir = WorldReflectionVector(worldPos, normalWorld);
	half4 reflectCol = _EnvMap.SampleLevel(_EnvMapSampler, reflectDir, _LodLevel);

	reflectCol.xyz = reflectCol.xyz * reflectCol.w * 6.0;

	mainColor = float4(reflectCol.xyz, 1.0);
}
ENDCG
#END
