

#DEFPARAMS
TEXELSIZE = { "TexelSize", VEC2, "0.0,0.0" },
#END

#DEFTAG
ShaderName = "UpSample"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_SRC_A;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_SRC_A_Sampler;
float BLOOM_INTENSITY;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
  // accumulation
  mainColor  = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, i.uv );
  mainColor.xyz += (TEXTURE_SRC_A.Sample( TEXTURE_SRC_A_Sampler, i.uv ) * BLOOM_INTENSITY).xyz;
}
ENDCG
#END
