local apolloDefine = require "apolloutility.defiend"
local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local apollocore = require "apollocore"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local defined = require "apolloutility.defiend"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local textureloader = require "apolloutility.asynctexture.textureloader"
local GiftManager = require "gifteffect.giftmanager"
local Keyboard = require "apolloengine.inputdelegate.keyboarddelegate"
local ED = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
require "utility"

local smartEnhanceProxy = require "smartEnhanceProxy"

local TAG = "main_gift"

--暂时关闭JIT防止JIT失败导致的效率下降
if _PLATFORM_ANDROID or _PROFILER then
    jit.off();
    jit.flush();
    LOG("turn off jit")
end

local main = {}

_NeedPause = function()
  main:_NeedPause();
end


if _KRATOSEDITOR then
    main._Agent = main
else
    g_callbackhandle = main
    gMain = main

    --初始化回调
    main.servicecallbacks = {}
    main.callbackindex = 1
    setmetatable(main.servicecallbacks, {__mode = "v"}) --弱引用
    --以下为固定接口
    function main:RegisterCallback(func)
        local index = self.callbackindex
        self.callbackindex = self.callbackindex + 1
        self.servicecallbacks[index] = func
        return self._Agent, index
    end

    function main:CallbackFunction(index, ...)
        --_COROUTINES_ON();
        local func = self.servicecallbacks[index]
        local res = true
        if func then
            res = func(...)
        end
        --_COROUTINES_OFF();
        return res
    end
end

function main:Initialize()
  _COROUTINES_ON()
  
  LOG(string.format("[%s::initialize]", TAG))

  GiftManager:Initialize();

  if _PLATFORM_WINDOWS then
    self:_WindowsPlatformInit();
  end
      
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "SyncUpdate") --添加同步更新
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");

  --self.begintime = venuscore.ITimerSystem:GetTimevalue()
  self.cumtime = 0
  self.fps = 0

  LOG(string.format("[%s::initialize] done", TAG))

  _COROUTINES_OFF()

  return true
end

function main:SetOutputTarget(fbo, texture)
  WARNING("main:SetOutputTarget");
  self.rendertarget = apolloengine.RenderTargetEntity() --创建一个FBO
  self.rendertarget:PushMetadata(
    --设置FBO格式
    apolloengine.RenderTargetResourceMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.Framework:GetResolution(),
      --分辨率
      fbo
    )
  )
  --增加color0纹理
  self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0)  
    self.outputtexture:PushMetadata(
      --创建纹理
      apolloengine.TextureResourceMetadata(apolloengine.Framework:GetResolution(), texture)
    )
  self.rendertarget:CreateResource()
  
  --给礼物场景设置渲染目标
  GiftManager:SetOutputTarget(self.rendertarget);

  return true
end

--param: path(gift scene path)
--return: int(gift handle)
function main:AddGift(path)
  local res = -1;
  _COROUTINES_ON()
  res = GiftManager:AddGift(path);
  
  if _PLATFORM_WINDOWS then
    --给礼物场景设置渲染目标
    GiftManager:SetOutputTarget(self.rendertarget);
  end
  _COROUTINES_OFF()
  return res;
end

--param: handle(gift handle)
--rerurn: bool
function main:RemoveGift(handle)
  local res = false;
  _COROUTINES_ON()
  res = GiftManager:ReleaseGift(handle);
  _COROUTINES_OFF()
  return res;
end

function main:ReleaseAllGift()
  _COROUTINES_ON()
  GiftManager:ReleaseAllGift();
  _COROUTINES_OFF()
  return true
end


--更改礼物部件的属性(颜色/花纹/头像)
function main:SetAttribute(attributeName,attributeValue)
  local res = false;
  _COROUTINES_ON()
  res = GiftManager:SetAttribute(attributeName,attributeValue);
  _COROUTINES_OFF()
  return res;
end

--播放场景
function main:PlayGift()
  local res = false;
  _COROUTINES_ON()
  --delta time重新计时
  self.begintime = nil;
  res = GiftManager:PlayGift();
  _COROUTINES_OFF()
  return res;
end

--预览场景
function main:PreviewGift()
  local res = false;
  _COROUTINES_ON()
  --delta time重新计时
  self.begintime = nil;
  res = GiftManager:PreviewGift();
  _COROUTINES_OFF()
  return res;
end

function main:ZoomGift(zoom)
  _COROUTINES_ON()
  GiftManager:ZoomGift(zoom);
  _COROUTINES_OFF()
  return true;
end

function main:RotateGift(xAngle,yAngle)
  _COROUTINES_ON()
  GiftManager:RotateGift(xAngle,yAngle);
  _COROUTINES_OFF()
  return true;
end

function main:ResetGift()
  _COROUTINES_ON()
  GiftManager:ResetGift();
  _COROUTINES_OFF()
  return true;
end

--外面通知可以开始截定制效果图了
function main:CaptureGift()
  _COROUTINES_ON()
  GiftManager:StartCapture();
  _COROUTINES_OFF()
  return true;
end




if _PLATFORM_WINDOWS then
  function main:_WindowsPlatformInit()
    
    --创建一个Windows平台场景，用来把礼物FBO绘制到屏幕上
    self.windowsScene = apolloengine.SceneManager:CreateScene("WindowsShellScene");
    self.windowsScene:SetSequence(1000000);  --确保此场景最后绘制
    
    --创建相机
    local windowsCam = self.windowsScene:CreateNode(apolloengine.Node.CT_NODE);
    windowsCam:SetName("WindowsCamera")
    local winCamComp = windowsCam:CreateComponent(apolloengine.Node.CT_CAMERA);
    winCamComp:CreateRealCameraProjection(0.01, 20) --设置摄像机
    winCamComp:LookAt(mathfunction.vector3(0, 0, 1), 
      mathfunction.vector3(0, 0, -1), mathfunction.vector3(0, 1, 0))
    winCamComp:Recalculate() --手动更新矩阵
    winCamComp:Activate();--激活主摄像机
    local clearFlag = apolloengine.RenderTargetEntity.CF_DEPTH;
    --winCamComp:SetClearFlag(clearFlag); --不清屏(因为是直接绘到主相机上的)
    
    
    --创建一个QUAD NODE用来贴礼物FBO到屏幕
    local winBlitNode = self.windowsScene:CreateNode(apolloengine.Node.CT_NODE);
    local internalRender = winBlitNode:CreateComponent(apolloengine.Node.CT_RENDER);
    internalRender:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata(defined.blit_material_forward_path)));
    internalRender:PushMetadata(
      apolloengine.RenderObjectMeshMetadate( 
      apolloengine.RenderComponent.RM_TRIANGLES,      
      apolloengine.QuadVertexMetadata(true, false),
      apolloengine.QuadIndicesMetadata()));
    internalRender:CreateResource();
    

    --创建一个RT
    self.rendertarget = apolloengine.RenderTargetEntity() --创建一个FBO
    self.rendertarget:PushMetadata(
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));
    
    self.depth = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
    self.depth:PushMetadata(
      apolloengine.DepthRenderBufferMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution(),
        apolloengine.TextureEntity.PF_DEPTH24_STENCIL8));
    
    --增加color0纹理
    self.color = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
    self.color:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution()));
    
    self.rendertarget:CreateResource()
    
    
    --self:AddGift("test:gift/car_gift_test14/scene.json");
    --给礼物场景设置渲染目标
    --GiftManager:SetOutputTarget(self.rendertarget);
    
    --设置FBO纹理给BlitNode
    internalRender:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.color);
    
    --windows平台做重定向(DEVICE/LASTQUEUE都重定向为序列帧纹理)
    --可能不需要(礼物素材中会有摄像头纹理吗？)
    --[[
    textureloader:Initialize();
    self.imagereader = asynctexture();
    self.imagereader:SetKeepSource(true);
    self.imagereader:SequentialLoad(30, true, 1, "test:palm/output%04d.jpg", nil);
    self.imagereader:Preloading();
    --]]
  end
  
  function main:_WindowsPlatformUpdate(spantime)
    --windows平台下为素材中的DEVICE/LASTQUEUE重定向
    
    local rgb, alpha, frame, isplaying = 0;
    rgb, frame, alpha, isplaying = self.imagereader:Update(spantime);
    apolloengine.DeviceResource:PushDeviceResource(
      apolloengine.DeviceResource.DEVICE_CAPTURE,
      rgb);
    apolloengine.DeviceResource:PushDeviceResource(
      apolloDefine.LAST_QUEUE_TEXTURE,
      rgb);
      
  end
  
  --删除Windows下模拟端内的Scene
  function main:_WindowsPlatformRelease()
    local sceneID = self.windowsScene:GetStaticID();
    apolloengine.SceneManager:DeleteSceneByID(sceneID);
  end
  
  
end

function main:Exit()
  --WARNING("*************************************************************main cutter");
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "SyncUpdate")
  apolloengine.Framework:RemoveTouchCallback(self._Agent, "OnTouch");
  if _PLATFORM_WINDOWS then
    self:_WindowsPlatformRelease();
  end
  self:ReleaseAllGift();
  return true
end


function main:OnResizeView(x, y, w, h)
    LOG(string.format("[%s::OnResizeView]%d %d %d %d", TAG, x, y, w, h))
end


function main:Timespan()
  local def = 0.0;
  local now = venuscore.ITimerSystem:GetTimevalue()
  if self.begintime ~= nil then
    def = now - self.begintime
  end
  self.begintime = now
  
  

  self.cumtime = self.cumtime + def
  self.fps = self.fps + 1
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime
    self.fps = 0
    self.cumtime = 0
    LOG("logic fps " .. fps)
  end
  return def
end

function main:SyncUpdate()
  _COROUTINES_ON();
  self:_Running()
  _COROUTINES_OFF();
end

function main:Update()
  self:_Running()
end




function main:OnRecordStart()
  return true
end

function main:_DispatchScreenRotation()
  local staticID = BD.Event.ScreenRotationChangePath
  if ED:HasCompListener(staticID) then
    -- someone want rotation data
    local type = BD.Event.ScreenRotationEvent.SCREEN_ROTATION_CHANGE
    local hasRotation = ED:HasEventListener(staticID, type);
    if hasRotation then
      local rotation = likeapp.AI:GetScreenRotation();
      local event = {
        staticID = staticID;
        eventType = type;
        params = rotation;
      };
      ED:PushEvent(event);
    end
  end
end

-- 手势缩放 和 旋转
function main:_DispatchTouchGesture()

  local eBegin = BD.Event.GestureGlobalEvent.GESTURE_BEGIN
  local eKeep  = BD.Event.GestureGlobalEvent.GESTURE_KEEP
  local eEnd   = BD.Event.GestureGlobalEvent.GESTURE_END

  local tBegin = apolloengine.SensorsTrackingComponent.VALUE_GESTURE_BEGIN
  local tKeep = apolloengine.SensorsTrackingComponent.VALUE_GESTURE_KEEP
  local tEnd = apolloengine.SensorsTrackingComponent.VALUE_GESTURE_END

  local staticID = BD.Event.GestureScalePath
  local actionSystem = apolloengine.IActionSystem

  if ED:HasCompListener(staticID) then

    local sensorType = apolloengine.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_SCALE

    local number = actionSystem:GetSensorDataCount(sensorType)
    for i = 1, number do
      local result = actionSystem:GetSensorDataByIndex(sensorType, i);
      local eventType
      if result.value == tBegin then
        eventType = eBegin
      elseif   result.value == tKeep then
        eventType = eKeep
      elseif result.value == tEnd then
        eventType = eEnd
      end
      if eventType ~= nil then
        local event = {
          staticID = staticID;
          eventType = eventType;
          params = result ; -- params is {value = KEEP, code = scaleValue, x = 0.0, y = 0.0 } -- scale center or rotate center
        };
        ED:PushEvent(event);
      end
    end

  end


  staticID = BD.Event.GestureRotatePath
  if ED:HasCompListener(staticID) then

    local sensorType = apolloengine.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_ROTATE

    local number = actionSystem:GetSensorDataCount(sensorType)
    for i = 1, number do
      local result = actionSystem:GetSensorDataByIndex(sensorType, i);
      local eventType
      if result.value == tBegin then
        eventType = eBegin
      elseif   result.value == tKeep then
        eventType = eKeep
      elseif result.value == tEnd then
        eventType = eEnd
      end
      if eventType ~= nil then
        local event = {
          staticID = staticID;
          eventType = eventType;
          params = result ; -- params is {value = KEEP, code = scaleValue, x = 0.0, y = 0.0 } -- scale center or rotate center
        };
        ED:PushEvent(event);
      end
    end

  end

end


function main:OnTouch(touchinfo)
  _COROUTINES_ON()
  if ED:HasCompListener(BD.Event.TouchGlobalPath) then

    local ePress = BD.Event.TouchGlobalEvent.TOUCH_PRESS
    local eMove = BD.Event.TouchGlobalEvent.TOUCH_MOVE
    local eRelease = BD.Event.TouchGlobalEvent.TOUCH_RELEASE
    local path = BD.Event.TouchGlobalPath

    local tPress = apolloengine.TouchInfo.TT_PRESS
    local tMove = apolloengine.TouchInfo.TT_MOVE
    local tRelease = apolloengine.TouchInfo.TT_RELEASE

    local hasPress = ED:HasEventListener(path, ePress)
    local hasMove = ED:HasEventListener(path, eMove)
    local hasRelease = ED:HasEventListener(path, eRelease )

    local PointCount = touchinfo:GetPointCount();
    for i = 1, PointCount do

      local touchType = touchinfo:GetTouchType(i);

      if touchType == tPress then

        if hasPress then
          local event = {
            staticID = BD.Event.TouchGlobalPath;
            eventType = ePress;
            params = {
              index = touchinfo:GetTouchID(i),
              point = touchinfo:GetTouchPoint(i) -- vector2f
            };
          };
          ED:PushEvent(event);
        end

      elseif touchType == tMove then

        if hasMove then
          local event = {
            staticID = BD.Event.TouchGlobalPath;
            eventType = eMove;
            params = {
              index = touchinfo:GetTouchID(i),
              point = touchinfo:GetTouchPoint(i) -- vector2f
            };
          };
          ED:PushEvent(event);
        end

      elseif touchType == tRelease then

        if hasRelease then
          local event = {
            staticID = BD.Event.TouchGlobalPath;
            eventType = eRelease;
            params = {
              index = touchinfo:GetTouchID(i),
              point = touchinfo:GetTouchPoint(i) -- vector2f
            };
          };
          ED:PushEvent(event);
        end

      end
    end
  end
  _COROUTINES_OFF();
end


function main:_Running()
  _COROUTINES_ON()
  local delts = self:Timespan()
  self:_DispatchScreenRotation();
  self:_DispatchTouchGesture();
  if _PLATFORM_WINDOWS then
    --self:_WindowsPlatformUpdate(delts);
  end
  GiftManager:Update(delts);
  --_PROFILER_UPDATE()
  _COROUTINES_OFF()
end

return main
