local Object = require "classic"
local ae = require "apolloengine"
local am = require "mathfunction"
local venusjson = require "venusjson"
require "utility"
local apolloDefine = require "apolloutility.defined"




local Rendernode = Object:extend()


--0-------2
--|	    / |
--|	  /   |
--| / 	  |
--1-------3
function Rendernode:new(flip, rootpath, effectsfile)

  local scene = ae.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(ae.Node.CT_NODE);
  --self.node = ae.Node();--创建基础节点
  self.render = self.node:CreateComponent(ae.Node.CT_RENDER);--创建基础渲染组建
  self.vertexstream = ae.VertexStream();--创建顶点流
  --设置顶点流提供位置以及纹理坐标两个属性，且原始数据格式为float格式，目标格式（显存中的数据格式）为半浮点，数据的个数为4个float和2个float
  self.vertexstream:SetVertexType(ae.ShaderEntity.ATTRIBUTE_POSITION,ae.VertexBufferEntity.DT_FLOAT,ae.VertexBufferEntity.DT_HALF_FLOAT,4);
  self.vertexstream:SetVertexType(ae.ShaderEntity.ATTRIBUTE_COORDNATE0,ae.VertexBufferEntity.DT_FLOAT,ae.VertexBufferEntity.DT_HALF_FLOAT,2);
  self.vertexstream:ReserveBuffer(4);--预先分配4个顶点的内存
  
  local config = venusjson.LaodJsonFile(effectsfile);
  self.name = config.id;
  local material = rootpath..config.material;
  local imagergb = rootpath..config.imagePathFormat;
  local imagealpha = config.alphaPathFormat and rootpath..config.alphaPathFormat or nil;
  
  local imageW = config.imageSize[1];
  local imageH = config.imageSize[2];

  local beginX = config.imageChipRect[1];
  local beginY = config.imageChipRect[2];
  local endX = config.imageChipRect[3];
  local endY = config.imageChipRect[4];
  
  local beginU = beginX / imageW;
  local beginV = beginY / imageH;
  local endU = endX / imageW;
  local endV = endY / imageH;
  

  self.resolution = ae.Framework:GetResolution();--获取渲染分辨率
  
  self.scale = 0.5 * flip * (endX - beginX) / (endY - beginY);--计算比率，在计算坐标点的时候等比例缩放x，y
  
  --初始化顶点
  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, am.vector4(0,0,0,1));
  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_COORDNATE0, am.vector2(beginU, beginV));

  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, am.vector4(0,0,0,1));
  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_COORDNATE0, am.vector2(beginU, endV));

  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, am.vector4(0,0,0,1));
  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_COORDNATE0, am.vector2(endU, beginV));
  
  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, am.vector4(0,0,0,1));
  self.vertexstream:PushVertexData(ae.ShaderEntity.ATTRIBUTE_COORDNATE0, am.vector2(endU, endV));

  
  self.render:PushMetadata(--传入材质原始数据
    ae.RenderObjectMaterialMetadata(
      ae.PathMetadata(material)));

  self.render:PushMetadata(--传入纹理原始数据
    ae.RenderObjectTextureMetadata(
      ae.ShaderEntity.TEXTURE_DIFFUSE,--此纹理为diffuse
      ae.TextureFileMetadata(imagergb)));
  if imagealpha then
    self.render:PushMetadata(--传入纹理原始数据
      ae.RenderObjectTextureMetadata(
        ae.ShaderEntity.TEXTURE_OPACITY,--此纹理为透明贴图
        ae.TextureFileMetadata(imagealpha)));
  end
    
  
  self.render:PushMetadata(--创建可以渲染的顶点流
		ae.RenderObjectMeshMetadate( 
			ae.RenderComponent.RM_TRIANGLES,      
      ae.ReferenceVertexMetadata(
        ae.VertexBufferEntity.MU_DYNAMIC,
        self.vertexstream),
      ae.QuadIndicesMetadata()));
  
  self.render:CreateResource();
end


local function _toRelativeCoordinates(res, pos)
  return am.vector2( pos:x() / res:x() * 2 - 1, (res:y() - pos:y()) / res:y() * 2 - 1 );
end

function Rendernode:_UpdateZeroPoint()
  return am.vector4(-1, 1, 0, 1),
    am.vector4(-1, -1, 0, 1),
    am.vector4(1, 1, 0, 1),
    am.vector4(1, -1, 0, 1);
end

function Rendernode:_UpdateTwoPoint(k1, k2)
  local kpdir = k1 - k2;--计算像素位置的差值，得到长度向量
  local vtcl = am.vector2(kpdir:y(), -kpdir:x()) * self.scale;--计算该向量的垂直向量，并且乘比例数值，保证等比缩放
  local p1 = _toRelativeCoordinates(self.resolution, k1 + vtcl);
  local p2 = _toRelativeCoordinates(self.resolution, k2 + vtcl);
  local p3 = _toRelativeCoordinates(self.resolution, k1 - vtcl);
  local p4 = _toRelativeCoordinates(self.resolution, k2 - vtcl);
  return
    am.vector4(p1:x(), p1:y(), 0, 1),
    am.vector4(p2:x(), p2:y(), 0, 1),
    am.vector4(p3:x(), p3:y(), 0, 1),
    am.vector4(p4:x(), p4:y(), 0, 1);
end

function Rendernode:_UpdateFourPoint(k1, k2, k3, k4)
  local p1 = _toRelativeCoordinates(self.resolution, k1);
  local p2 = _toRelativeCoordinates(self.resolution, k2);
  local p3 = _toRelativeCoordinates(self.resolution, k3);
  local p4 = _toRelativeCoordinates(self.resolution, k4);
  return
    am.vector4(p1:x(), p1:y(), 0, 1),
    am.vector4(p2:x(), p2:y(), 0, 1),
    am.vector4(p3:x(), p3:y(), 0, 1),
    am.vector4(p4:x(), p4:y(), 0, 1);
end


function Rendernode:UpdateRender(kpoint1, kpoint2, kpoint3, kpoint4)--传如2个点或者4个点，用来更新一个可以渲染的可渲染节点
  local vs1,vs2,vs3,vs4;
  if nil == kpoint1 or nil == kpoint2 then
    vs1,vs2,vs3,vs4 = self:_UpdateZeroPoint();
  elseif nil == kpoint3 or nil == kpoint4 then
    vs1,vs2,vs3,vs4 = self:_UpdateTwoPoint(kpoint1, kpoint2);
  else
    vs1,vs2,vs3,vs4 = self:_UpdateFourPoint(kpoint1, kpoint2, kpoint3, kpoint4);
  end  
  self.vertexstream:ChangeVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, 1, vs1);
  self.vertexstream:ChangeVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, 2, vs2);
  self.vertexstream:ChangeVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, 3, vs3);
  self.vertexstream:ChangeVertexData(ae.ShaderEntity.ATTRIBUTE_POSITION, 4, vs4);  
  self.render:ChangeVertexBuffer(self.vertexstream);
end

return Rendernode;