local venusjson = require "venusjson"
local venuscore = require "venuscore"
local renderqueue = require "apolloutility.renderqueue"

local maxtimespan = 1 / 15
local filter = {}
--考虑存在多个滤镜的情况

--增加脚本路径
function filter:_AddScriptPath(pathDir)
  
  --local gamepath = venuscore.IFileSystem:PathAssembly("root:lightgame");
  --gamepath = (gamepath.."/?.lua;")..(gamepath.."/?/?.lua;")..(gamepath.."/?/init.lua;");
  --gamepath ="E:/faceDeformationDev/master/algo_video_facecute/lightgame/sticker/..";
  --gamepath = (gamepath.."/?.lua;");
  self.originPackagePath = package.path;
  local gamepath=venuscore.IFileSystem:PathAssembly(pathDir);
  gamepath=gamepath.."/?.lua;";
  package.path =gamepath.. package.path;
end

--删除脚本路径
function filter:_RemoveScriptPath()  
  if self.originPackagePath then
    package.path = self.originPackagePath;
  end 
end

function filter:Initialize(layer)
  --self.maincamera = maincamera;
  self.cameraLayer = layer;
  self.filtertable = {}
end

function filter:_SplitConfig(rootconfig) 
  self.filtername = rootconfig.filter.mainscript;
end

function filter:LoadConfig(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.filter then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    self:_AddScriptPath(pathDir);
    self:_SplitConfig(rootconfig);
    local rootdir = pathDir.."/"; 
    venuscore.IFileSystem:SetResourcePath(rootdir);

    rootdir = self:_CheckReplace(rootdir);
    local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(rootdir..self.filtername));
    if not errorstr then
      local temp= func(); 
      local tmpCamera = renderqueue:GetCamera(self.cameraLayer);
      temp:Initialize(tmpCamera,rootconfig);
      table.insert(self.filtertable,temp);
      return true;
    else  
      ERROR(errorstr);
      return false;
    end
  end
  return true;
end 

--考虑存在多个滤镜时的情况
function filter:Update(def)
  def = math.min(def, maxtimespan);
  for key,values in pairs(self.filtertable) do
     if values then
      values:Update(def);
     end
  end
end

function filter:OnRecordStart()
  if self.filtertable then
    for key,values in pairs(self.filtertable) do
      if values and values.OnRecordStart then
        values:OnRecordStart();
      end
    end
  end
end

function filter:ReleaseResource()
  if next(self.filtertable) ~= nil then
    for key,values in pairs(self.filtertable) do
      if values then
        values:Exit();
      end    
    end
    self:_RemoveScriptPath();
    self.filtertable = {};
  end
end

-- 替换回归2 tap素材路径
function filter:_CheckReplace(root)
  --liuqian 该段代码是为了兼容老素材中，自己带有lua脚本以及材质球
  --         查找到这些素材后，进行重定向到venusroot中，以方便维护
  --组合字符串，根据shader判断是否属于那个老特效进行重定向
  local comOldPath = root.."filter".."/resource".."/material";
  --2274\2330\2083
  local dramticP = comOldPath.."/dramadolly.shader";
  local isDramtic = venuscore.IFileSystem:isFileExist(dramticP);
  --2275\1689
  local tuijingmouthP = comOldPath.."/dolly.shader";
  local isTuijingmouth = venuscore.IFileSystem:isFileExist(tuijingmouthP);
  --2534
  local tuijing1P = comOldPath.."/windolly.shader";
  local isTuijing1 = venuscore.IFileSystem:isFileExist(tuijing1P);
  --2535
  local tuijing2P = comOldPath.."/whydolly.shader";
  local isTuijing2 = venuscore.IFileSystem:isFileExist(tuijing2P);
  
  if self.filtername == "filter/spiltscreenmain.lua" then
    local newRoot = "docs:filter/halfcolor/";
    return newRoot;
  elseif self.filtername == "filter/historicalrgbmain.lua" then
    local newRoot = "docs:filter/historicalrgb/";
    return newRoot;
  elseif self.filtername == "filter/mlaamain.lua" then
    local newRoot = "comm:script/";
    return newRoot;
  elseif self.filtername == "filter/ripplemain.lua" then
    local newRoot = "docs:filter/ripple/";
    return newRoot;
  elseif self.filtername == "filter/dollymain.lua" and isDramtic then
    local newRoot = "docs:filter/dramatic/";
    return newRoot;
  elseif self.filtername == "filter/dollymain.lua" and isTuijingmouth then
    local newRoot = "docs:filter/tuijingmouth/";
    return newRoot;
  elseif self.filtername == "filter/dollymain.lua" and isTuijing1 then
    local newRoot = "docs:filter/tuijing1/";
    return newRoot;
  elseif self.filtername == "filter/dollymain.lua" and isTuijing2 then
    local newRoot = "docs:filter/tuijing2/";
    return newRoot;
  end
  return root;
end

return filter;