--require "venusdebug"
local Object = require "classic"
local FiniteStateMachine = Object:extend();


-- FSM CONSTANTS --------------------------------------------------------------
local SEPARATOR = '.'
local ANY       = '*'
local ANYSTATE  = ANY .. SEPARATOR -- *.  可以表达出任意的 状态
local ANYEVENT  = SEPARATOR .. ANY -- .*  可以表达出任意的 事件
local UNKNOWN   = ANYSTATE .. ANY  -- *.* 可以表达出任意的 状态.事件

--根据传入的 状态转移表 构建 有限状态机
function FiniteStateMachine:new(STT)
	self.cur_state = {}
	self.stt = {}
	self.target_list = {} --当前的状态转移项
	self.event_list = {}

	-- creat self.stt from STT
	for _,v in ipairs(STT) do

		local preStates, event, newState, action, randomShow = v[1], v[2], v[3], v[4], v[5]

		if event == "" then
			event = ANY
		end
		self.event_list[event] = 1

		if next(preStates) ~= nil then --若状态转移表中的preState不为空，将其当前状态转移项插入stt中

			for _, preState in pairs(preStates) do --json文件中一个preState可能对应多个后续状态

				local condition = preState .. SEPARATOR .. event

				if self.stt[condition] == nil then --若之前self.stt表格中没有preState，直接赋值

					self.stt[condition] = {newState = newState, action = action, randomShow = randomShow}

				elseif self.stt[condition] ~= nil then --若之前self.stt表格中有preState，将后续状态插入已有的preState中的newState与action中

					for k2, v2 in pairs(newState) do
						self.stt[condition].newState[k2] = v2
					end

					if self.stt[ANY .. SEPARATOR .. event] ~= nil then

						for _, v2 in pairs(action) do

							local existflag = false

							for _, v3 in pairs(self.stt[ANY .. SEPARATOR .. event].action) do
								if v3.targetPart == v2.targetPart then
									existflag = true
									break
								end
							end

							if existflag == false then
								table.insert(self.stt[ANY .. SEPARATOR .. event].action, v2)
							end
						end
					end
				end
			end
		elseif next(preStates) == nil then -- 若状态转移表中的preState为空，那么说明当前状态转移项不需要前置状态
			if self.stt[ANY .. SEPARATOR .. event] == nil then--json文件中一个preState可能对应多个后续状态
				self.stt[ANY .. SEPARATOR .. event] = {newState = newState, action = action, randomShow = randomShow}
			elseif self.stt[ANY .. SEPARATOR .. event] ~= nil then --若之前self.stt表格中有preState，将后续状态插入已有的preState中的newState与action中
				for k2,v2 in pairs(newState) do
					self.stt[ANY .. SEPARATOR .. event].newState[k2] = v2
				end
				if self.stt[ANY .. SEPARATOR .. event] ~= nil then
					for _,v2 in pairs(action) do
						local existflag = false
						for _,v3 in pairs(self.stt[ANY .. SEPARATOR .. event].action) do
							if v3.targetPart == v2.targetPart then existflag = true break end
						end
						if existflag == false then
							table.insert(self.stt[ANY .. SEPARATOR .. event].action , v2 )
						end
					end
				end
			end
		end
	end
end

function FiniteStateMachine:fire(event)
	local result = "."--result负责返回触发成功的前提条件
	-- 深度拷贝当前状态表至cur_state1
	local cur_state1 = {}
	for k,v in pairs(self.cur_state) do
		cur_state1[k] = v;
	end
	self.target_list = {}
	local flag = false --默认在stt表格中找不到对应的状态转移项
	for part, state in pairs(self.cur_state) do
		local str = part .. SEPARATOR .. state .. SEPARATOR .. event
		local act = self.stt[str]
		if act~=nil then --若[状态.行为]可以在stt表格中找到对应的状态转移项，则实现状态转移并且运行函数
			flag = true
			result = part .. SEPARATOR .. state
			--self.target_list = {}
			if act.randomShow == true then--随机更新当前的一个当前状态以及状态转移项
				local act_size = #act.action
				local idx = math.random(act_size)
				--idx = 1
				table.insert(self.target_list,act.action[idx])
				print("randomShow = true",act.action[idx].targetPart,act.action[idx].targetState)
				cur_state1[act.action[idx].targetPart] = act.action[idx].targetState
			else --更新全部的当前状态和状态转移项
				for idx=1,#act.action do
					local act_targetPart = act.action[idx].targetPart
					local act_targetState = act.action[idx].targetState

					--应该支持从非playing到非playing状态转移这种情况
					table.insert(self.target_list,act.action[idx])
					cur_state1[act_targetPart] = act_targetState

					--if(act_targetState == "playing") then --要改变的状态为playing状态，改变
					--	table.insert(self.target_list,act.action[idx])
					--	cur_state1[act_targetPart] = act_targetState
					--elseif(self.cur_state[act_targetPart]=="playing") then--当前状态为playing状态，改变
					--	table.insert(self.target_list,act.action[idx])
					--	cur_state1[act_targetPart] = act_targetState
					--end
				end				
			end
		end
	end
	if flag == true then -- 若[状态.行为]可以在stt表格中找到对应的状态转移项，则将当前状态置为cur_state1
		self.cur_state = cur_state1
	else -- 若[状态.行为]不可以在stt表格中找到对应的状态转移项，则开始找[*.行为]
		local str = ANY .. SEPARATOR .. event
		local act = self.stt[str]
		if act ~= nil then --若[*.行为]可以在stt表格中找到对应的状态转移项
			result = ANY
			--self.target_list = {}
			if act.randomShow == true then--随机更新当前的一个当前状态以及状态转移项
				local act_size = #act.action
				local idx = math.random(act_size)
				--idx = 1
				table.insert(self.target_list,act.action[idx])
				print("randomShow = true",act.action[idx].targetPart,act.action[idx].targetState)
				cur_state1[act.action[idx].targetPart] = act.action[idx].targetState
			else --更新全部的当前状态和状态转移项
				for idx=1,#act.action do
					local act_targetPart = act.action[idx].targetPart
					local act_targetState = act.action[idx].targetState

					--应该支持从非playing到非playing状态转移这种情况
					table.insert(self.target_list,act.action[idx])
					cur_state1[act_targetPart] = act_targetState

					--if(act_targetState == "playing") then --要改变的状态为playing状态，改变
					--	table.insert(self.target_list,act.action[idx])
					--	cur_state1[act_targetPart] = act_targetState
					--elseif(self.cur_state[act_targetPart]=="playing") then--当前状态为playing状态，改变
					--	table.insert(self.target_list,act.action[idx])
					--	cur_state1[act_targetPart] = act_targetState
					--end
				end
			end
			self.cur_state = cur_state1
		else --若[*.行为]不可以在stt表格中找到对应的状态转移项，则保持原状态不变
			result = "."
		end
	end
	return result
end

function FiniteStateMachine:get()
  print("cur_status is : ")
  if next(self.cur_state) == nil then
    print("the state is nil\n")
  else 
    print("{")
    for k,v in pairs(self.cur_state) do
      print("\t",k.. '.' ..v)
    end
    print("}")
  end
  print("transitions is :")
  if(next(self.target_list)==nil) then
	print("the transitions is nil")
  else
	print("{")
	for _,v in pairs(self.target_list) do
		print("\t",v.targetPart .. '.' .. v.targetState)
	end
	print("}")
  end
  print("---------------------------------------\n")

end

return FiniteStateMachine;