local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"

local particle = require "facecute.particle.particle"
local particle3 = particle:extend();

function particle3:Play()
  self:setState("playing")
  particle3.super.Play(self);
end

function particle3:Stop()
  self:setState("invisible")
  self:SetVisible(false);
end

function particle3:Stop()
  self:SetShow(false);
end


function particle3:Pause()
  self:setState("paused")
end

function particle3:PauseInFirstFrame()
  self:setState("first_frame")
end

function particle3:PauseInLastFrame()
  self:setState("last_frame")
end

function particle3:Hide()
  self:setState("invisible")
  self:Stop();
end


function particle3:TestTrigger()
  if self.triggerFlag then
    self.triggerFlag = false
    return self.cur_state3
  end
  return nil
end

function particle3:setState(state)
  if self.cur_state3 ~= state then
    self.triggerFlag = true
    self.cur_state3 = state
  end
end

function particle3:new(maincamera)
  self.cur_state3 = "invisible";
  self.triggerFlag = false;
  self.particlename = nil;
  particle3.super.new(self,maincamera);
end

function particle3:ParseConfig(config,para)
  self.particlename = config.name;
  return  particle3.super.ParseConfig(self,config,para);
end


function particle3:getAsset(name)
  if name==self.particlename then
    return self;
  end
 return nil;
end

return particle3;