local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local apolloengine = require "apollocore"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Editorscene = require "editorscene"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"


local EditorStyishManager = {}

function EditorStyishManager:Initialize(layer,resourceType)
  self.scene = nil;
  self.baseObjects = nil;
  self.layer = layer; 
  self.resourceType = resourceType;
end

function EditorStyishManager:LoadConfig(path)
  local rootConfig = venusjson.LaodJsonFile(path);
  if rootConfig.scene then
    renderqueue:Activate(layer);
    self.lastTex =  renderqueue:GetTexture(self.layer);
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_FILTER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_FILTER,
      self.lastTex);
    
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootDir = pathDir.."/"; 
    venuscore.IFileSystem:SetResourcePath(rootDir);
    local baseObject = self:_CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootConfig.scene));
    --local layer = self:_FindPreLayer(self.layer - 1);
    local newScene = Editorscene(self.layer,self.resourceType);
    
    newScene:LoadConfig(baseObject);
    --newScene.firstquadnode:SetShow(false);
    self.scene = newScene;
    self.baseObjects= baseObject;
  end
  return true;
end


function EditorStyishManager:_CreateInstanceFromBundle(path)
  local bundlePath = venuscore.IFileSystem:PathAssembly(path);
  --local str = venuscore.IFileSystem:ReadFile(path);
  --拿到facecute的Scene
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  local _,objects = BundleSystem:DeserializeFromPath(bundlePath,BundleSystem.DeserializeMode.Scene,scene);
  --return BundleSystem:DeSerialize(str,scene,BundleSystem.DeserializeMode.Scene);
  --return BundleSystem:DeSerialize(str);
  return objects;
end

function EditorStyishManager:OnRecordStart()
  if self.scene ~= nil then
    self.scene:OnRecordStart();
  end
end

function EditorStyishManager:ReleaseResource()
  self.baseObjects = nil;
  if self.scene then
    self.scene:ReleaseResource();
  end
  self.scene = nil;
  collectgarbage();
end

function EditorStyishManager:Update(def)
  if self.scene == nil then
    return
  end
  local tex = renderqueue:GetTexture(self.layer);
  if tex and tex:GetObjectID() ~= self.lastTex:GetObjectID() then
    self.lastTex = tex;
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_FILTER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_FILTER,
      self.lastTex);
  end
  self.scene:Update(def)
end

function EditorStyishManager:SetShow(show)
  local baseObjects = self.baseObjects;
  if baseObjects == nil then
    return
  end
  
  if show == true then
    for i = 1, #baseObjects do
      local renderCom = baseObjects[i]:GetComponent(apolloengine.Node.CT_RENDER)
      if renderCom then
        renderCom:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      end
      local cameraCom = baseObjects[i]:GetComponent(apolloengine.Node.CT_CAMERA)
      if cameraCom then
        cameraCom:Activate();
      end
    end
  else
    for i = 1, #baseObjects do
      local renderCom = baseObjects[i]:GetComponent(apolloengine.Node.CT_RENDER)
      if renderCom then
        renderCom:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      end
      local cameraCom = baseObjects[i]:GetComponent(apolloengine.Node.CT_CAMERA)
      if cameraCom then
        cameraCom:Deactivate();
      end
    end
  end
end

return EditorStyishManager;
