local apolloengine  = require "apolloengine"
local rendernode    = require "apolloutility.apollonode.rendernode"
local mathfunction  = require "mathfunction"
local venuscore     = require "venuscore"
local defined       = require "apolloutility.defiend"

local UvMoveBehavior = venuscore.VenusBehavior:extend("UvMoveBehavior");
local Timer_Param = "_ElapsedTime"

function UvMoveBehavior:new()  
  self.initialized  = false
end

function UvMoveBehavior:_OnAwake()
  local renderer = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
  if renderer == nil then
    LOG("[UvMoveBehavior]: Can not find render component.")
    return    
  end
  
  renderer:SetParameter(Timer_Param, mathfunction.vector1(0.0))

  self.renderer = renderer
  self.material = material
  self.elapsed_time = 0
  self.initialized = true
end

function UvMoveBehavior:_OnUpdate(timespan)
  if not self.initialized then
    return
  end
  
  local renderer = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
  if renderer == nil then
    LOG("[UvMoveBehavior]: Can not find render component.")
    return    
  end
  
  self.elapsed_time = self.elapsed_time + timespan  
  self.renderer:SetParameter(Timer_Param, mathfunction.vector1(self.elapsed_time))
end

return UvMoveBehavior;