local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local renderqueue = require "apolloutility.renderqueue"
local defined = require "apolloutility.defiend"
local videodecet = require "videodecet"
local likeapp = require "likeapp"
local maskrender = require "apolloutility.maskrender"
require "venusdebug"
require "utility"

local beauty = {}
beauty.facemax = 3;
beauty.partcount = 6;
beauty.partrenderqueue = {}
function beauty:Initialize(maincamera)
  self:_CreatRenderTarget(maincamera);
  self:_CreateTexture();
  local indexstreamleft = apolloengine.IndicesStream(); 
  indexstreamleft:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  indexstreamleft:ReserveBuffer(6);
    
  indexstreamleft:PushIndicesData(1);
  indexstreamleft:PushIndicesData(0);
  indexstreamleft:PushIndicesData(2);
  indexstreamleft:PushIndicesData(2);
  indexstreamleft:PushIndicesData(0);
  indexstreamleft:PushIndicesData(3);
  
  local indexstreamright = apolloengine.IndicesStream(); 
  indexstreamright:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  indexstreamright:ReserveBuffer(6);
  
  indexstreamright:PushIndicesData(1);
  indexstreamright:PushIndicesData(0);
  indexstreamright:PushIndicesData(2);
  indexstreamright:PushIndicesData(2);
  indexstreamright:PushIndicesData(0);
  indexstreamright:PushIndicesData(3);
  
  for i=1, self.facemax, 1 do
    local maskrenderleft = maskrender(4,6,indexstreamleft,mathfunction.vector4(1.0,1.0,1.0,1.0),self.masktex);
    local maskrenderright = maskrender(4,6,indexstreamleft,mathfunction.vector4(1.0,1.0,1.0,1.0),self.masktex);
    maskrenderleft:SetSequence(-2000);
    maskrenderright:SetSequence(-2000);
    table.insert(self.partrenderqueue,maskrenderleft);
    table.insert(self.partrenderqueue,maskrenderright);
  end
  
  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/blackcircles.lua");
  maincamera:AttachPostEffect(self.post);
  self.post:RegisterParameter("eyesmask")
  self.post:RegisterParameter("strengh")
    
end

function beauty:Update(def)
  
  self.leftpoints  = {};
  self.rightpoints = {};
  local faces = videodecet:GetFaces();
  for k=1, #faces, 1 do
    local faceinfo = faces[k];
    self.keypoints = faceinfo:GetKeypointArray();
    table.insert(self.leftpoints,self.keypoints[2]);
    table.insert(self.leftpoints,self.keypoints[5]);
    table.insert(self.leftpoints,self.keypoints[47]);
    table.insert(self.leftpoints,self.keypoints[79]);
    
    table.insert(self.rightpoints,self.keypoints[32]);
    table.insert(self.rightpoints,self.keypoints[29]);
    table.insert(self.rightpoints,self.keypoints[47]);
    table.insert(self.rightpoints,self.keypoints[80]);
    
    local vertexstreamleft = apolloengine.VertexStream();--创建顶点流
    vertexstreamleft:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      apolloengine.VertexBufferEntity.DT_FLOAT,
      apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
      2);
    vertexstreamleft:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
          2);
    vertexstreamleft:ReserveBuffer(4); 
    for i=1, 4, 1 do
      vertexstreamleft:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector2(self.leftpoints[i][1],self.leftpoints[i][2]));
    end
    
    vertexstreamleft:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.261, 0.466));
    vertexstreamleft:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.261, 0.597));
    vertexstreamleft:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.488, 0.597));
    vertexstreamleft:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.488, 0.466));
    
    
    local vertexstreamright = apolloengine.VertexStream();--创建顶点流
    vertexstreamright:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      apolloengine.VertexBufferEntity.DT_FLOAT,
      apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
      2);
    vertexstreamright:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
          2);
    vertexstreamright:ReserveBuffer(4); 
    
    for i=1, 4, 1 do
      vertexstreamright:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector2(self.rightpoints[i][1],self.rightpoints[i][2]));
    end
    
    vertexstreamright:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.714, 0.466));
    vertexstreamright:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.714, 0.597));
    vertexstreamright:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.488, 0.597));
    vertexstreamright:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0.488, 0.466));
    
    
    
    self.partrenderqueue[2*k-1]:SetShow(true);
    self.partrenderqueue[2*k-1]:Update(vertexstreamleft);
    self.partrenderqueue[2*k]:SetShow(true);
    self.partrenderqueue[2*k]:Update(vertexstreamright);
  end
  self.post["eyesmask"](self.post, self.tex);
end

function beauty:_CreatRenderTarget(maincamera)
  
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.Color(0.0,0.0,0.0,0.0); --清屏颜色
  
  self.mask_camera = apollonode.CameraNode();
  self.mask_camera:Activate();
  self.mask_camera:CreateRealCameraProjection(near, far);
  self.mask_camera:LookAt(pos, lookat, up);
  self.mask_camera:SetSequence(-2000);
  self.mask_camera:SetClearColor(color);
  
  self.rt = apolloengine.RenderTargetEntity();  
  self.rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));--分辨率
    
  self.tex = self.rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution()));
  self.rt:CreateResource();
  self.mask_camera:AttachRenderTarget(self.rt);
  
end

function beauty:_CreateTexture()
  self.maskPath = "docs:beauty/mask.png";
  self.masktex = apolloengine.TextureEntity();
  self.masktex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.maskPath));
  self.masktex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.masktex:CreateResource();
end

function beauty:SetStrength(strength)
  if self.post then
    self.post["strengh"](self.post, strength/100.0);
  end
end

function beauty:_ComputePoint(point1,point2,ratio)
  return {(point1[1] - point2[1])*ratio + point2[1],(point1[2] - point2[2])*ratio + point2[2]};
end


function beauty:Release()
  self.mask_camera:Deactivate();
  self.mask_camera = nil;
  self.rt = nil;
  self.tex = nil;
  self.post = nil;
  self.eyerenderqueue = {};
  self.keypoints = {};
end

return beauty;
