local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"
local apolloDefine = require "apolloutility.defined"

local CircleRender = Object:extend();

--传入圆心偏移，点的数量，材质，来创建一个可渲染的圆
function CircleRender:new(centeroffset, pointcount, material)
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_NODE);
  --self.node = apolloengine.Node();--创建基础节点
  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);--创建基础渲染组建
  self.trans = self.node:CreateComponent(apolloengine.Node.CT_TRANSFORM);--创建位置信息组件
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.indicesstream = apolloengine.IndicesStream();--创建索引流

  --初始化一个半径为1的圆
  
  self.render:PushMetadata(--传入材质原始数据
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(material)));
  
  self.render:PushMetadata(--传入信息创建元
		apolloengine.RenderObjectMeshMetadate( --mesh元信息
			apolloengine.RenderComponent.RM_TRIANGLES,--渲染方式  
      apolloengine.ReferenceVertexMetadata(--以索引方式传递顶点信息
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        self.vertexstream),
      apolloengine.ReferenceIndicesMetadata(--以索引方式传递索引信息
        apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
        self.indicesstream)));
end

--是否渲染
function CircleRender:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end  
end

--设置位置
function CircleRender:SetLocalPosition(pos)
  self.trans:SetLocalPosition(pos);
end

--设置缩放
function CircleRender:SetLocalScale(scale)
  self.trans:SetLocalScale(scale);
end

--返回node节点
function CircleRender:GetNode()
  return self.node;
end

--设置材质属性
function CircleRender:SetParameter(slot, value)
  self.render:SetParameter(slot, value);
end

--设置摄像机所属的队列
function CircleRender:SetSequence(s)
  self.render:SetSequence(s);
end

return CircleRender;