

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Comic"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_Lab;
Texture2D TEXTURE_uLut;
Texture2D TEXTURE_Outline;
SamplerState Lab_Sampler;
SamplerState uLut_Sampler;
SamplerState Outline_Sampler;
float UNIFORM_uS;
float UNIFORM_uLop;
float UNIFORM_uOin;
float UNIFORM_uSaturantion;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float3 c = TEXTURE_Lab.Sample(Lab_Sampler, i.uv).rgb;
    int currentLevel = getLevel(c.r, UNIFORM_uLop);
    c.r = applyLevel(currentLevel, UNIFORM_uLop);
	
    c = lab2rgb(c) * TEXTURE_Outline.Sample(Outline_Sampler, i.uv).r;
    c = clamp(c, 0., 1.);
	
	//gl_FragColor.rgb = (gl_FragColor.rgb - vec3(0.5)) * 1.2 + vec3(0.5);
	
	//vec3 hsv = rgb2hsv(c.rgb);
	//hsv.g = pow(hsv.g, uSat);
	//c.rgb = hsv2rgb(hsv);
	
	//if (abs(uOin) < 0.0001) 
	c = lut(c, TEXTURE_uLut, uLut_Sampler);
    //else c = lut(c.bgr,uLut).bgr;
	
	//c = lut(c.bgr,uLut).bgr;
	//c = LUT(vec4(c.bgr,1.0),uLut).bgr;
	
    mainColor = float4( abs(UNIFORM_uS - 1.0) < 0.0001 ? c.ggg : c, 1.0);
}
ENDCG
#END
