//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////



#SHADER_DEFINE BezierVertex

	FUNCTION_INPUT = 
	{
		{ LOCALSCREEN_TRANSVIEWPROJ,	HIGH,	MAT4,		"in_WorldViewPorj" },
		{ ATTRIBUTE_POSITION, 			  HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE1, 			    HIGH,	FLOAT,		"in_Radius" },
	}

	FUNCTION_OUTPUT = 
	{
		{ ATTRIBUTE_COORDNATE1, 		HIGH,	FLOAT,		"out_Radius" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"out_Pos" },
	}

#SHADER_CODE
  vec4 rotpos = in_WorldViewPorj * in_Position;
  float out_Radius = in_Radius;
  vec2 out_Pos = rotpos.xy/rotpos.w;
	gl_Position = rotpos;
#END_CODE
#END_DEFINE


#SHADER_DEFINE BezierFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		  NONE,	TEXTURE2D,	"in_Texture" },
    { TEXTURE_BEZIER, 		  NONE,	TEXTURE2D,	"in_TextureBZ" },
    { UNIFORM_CENTERPOS,	      HIGH,	VEC2,		"in_centerpos" },
    { UNIFORM_NEW_CENTERPOS,	  HIGH,	VEC2,		"in_newcenterpos" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		  "in_Pos" },    
		{ ATTRIBUTE_COORDNATE1, 		HIGH,	FLOAT,		  "in_dis" },
    { UNIFORM_RATIOASPECT, HIGH,	VEC2,	  "in_ratioaspect" },
	}
	
#SHADER_CODE


  float aspectRatio = in_ratioaspect.y/in_ratioaspect.x;
  vec2 center = vec2(in_centerpos.x,in_centerpos.y*aspectRatio);
  vec2 posCoordinateToUse = vec2(in_Pos.x, in_Pos.y*aspectRatio);
  vec2 newcenter = in_newcenterpos;
  newcenter.y = newcenter.y*aspectRatio;
  float newdis = distance(posCoordinateToUse,newcenter);
   if(newdis>0.0)
  {
      vec2 centerVector = normalize(center-newcenter);
      vec2 texVector = normalize(posCoordinateToUse-newcenter);
      float  ratio = in_dis;
      float bz = texture2D(in_TextureBZ, vec2(ratio,0.5)).r;
      float dis2= newdis/in_dis;
      vec2 texDeformation = texVector*dis2*bz+newcenter;
      texDeformation.y = texDeformation.y/aspectRatio;
      texDeformation.x=( texDeformation.x+1.0)/2.0;
      texDeformation.y=( texDeformation.y+1.0)/2.0;
      texDeformation=clamp(texDeformation,0.01,0.99);
      // texDeformation.y=1.0- texDeformation.y;
     //  clamp(texDeformation,0,1);
      gl_FragColor =  vec4(texture2D(in_Texture, texDeformation).rgb, 1.0);
  
  }
  else
  {
     vec2 texcoordCal = (in_Pos+vec2(1.0,1.0))/2.0;
    // texcoordCal.y = 1.0-texcoordCal.y;

   //   clamp(texcoordCal,0,1);
     gl_FragColor = vec4(texture2D(in_Texture, texcoordCal).rgb, 1.0);
  }
  
#END_CODE
#END_DEFINE
