
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_BEZIER = {"TEXTURE_BEZIER", TEXTURE2D, "white"},
UNIFORM_CENTERPOS = {"center pos", VEC2, "1.0,1.0"},
UNIFORM_NEW_CENTERPOS = {"new center pos", VEC2, "1.0,1.0"},
UNIFORM_RATIOASPECT = {"ratio aspect", VEC2, "1.0,1.0"},
#END

#DEFTAG
ShaderName = "bezier"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float in_Radius : TEXCOORD1;
};

struct v2f
{
	float2 out_Pos : TEXCOORD0;
	float out_Radius : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4 rotpos = mul(v.in_Position, LOCALSCREEN_TRANSVIEWPROJ);
	
	o.out_Radius = v.in_Radius;
	o.out_Pos = rotpos.xy / rotpos.w;
	o.vertex = UniformNDC(rotpos);
	return o;
}

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BEZIER;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BEZIER_Sampler;
float2 UNIFORM_CENTERPOS;
float2 UNIFORM_NEW_CENTERPOS;
float2 UNIFORM_RATIOASPECT;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	// translate var
	float2 in_centerpos = UNIFORM_CENTERPOS;
	float2 in_newcenterpos = UNIFORM_NEW_CENTERPOS;
	float2 in_Pos = float2(i.out_Pos.x, i.out_Pos.y);
	float in_dis = i.out_Radius;
	float2 in_ratioaspect = UNIFORM_RATIOASPECT.xy;
	float4 outColor;

    // code
	float aspectRatio = in_ratioaspect.y/in_ratioaspect.x;
    float2 center = float2(in_centerpos.x,in_centerpos.y*aspectRatio);
    float2 posCoordinateToUse = float2(in_Pos.x, in_Pos.y*aspectRatio);
    float2 newcenter = in_newcenterpos;
    newcenter.y = newcenter.y*aspectRatio;

    float newdis = distance(posCoordinateToUse,newcenter);
    if(newdis>0.0)
    {
      float2 centerVector = normalize(center-newcenter);
      float2 texVector = normalize(posCoordinateToUse-newcenter);
      float  ratio = in_dis;
      float bz = TEXTURE_BEZIER.Sample(TEXTURE_BEZIER_Sampler, float2(ratio,0.5)).r;
      float dis2= newdis/in_dis;
      float2 texDeformation = texVector*dis2*bz+newcenter;
      texDeformation.y = -texDeformation.y/aspectRatio;
      texDeformation.x=( texDeformation.x+1.0)/2.0;
      texDeformation.y=( texDeformation.y+1.0)/2.0;
      texDeformation=clamp(texDeformation,0.01,0.99);
      outColor =  float4(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, texDeformation).rgb, 1.0);
  	}
  	else
  	{
		in_Pos.y = -in_Pos.y;
     	float2 texcoordCal = (in_Pos+float2(1.0,1.0))/2.0;
        outColor = float4(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, texcoordCal).rgb, 1.0);
  	}

	mainColor = outColor;
}
ENDCG
#END

