/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Tray
extends Widget {
    int itemCount;
    TrayItem[] items;

    void destroyItem(TrayItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            TrayItem[] trayItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                TrayItem item = trayItemArray[n2];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.display.tray == this) {
            this.display.tray = null;
        }
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            TrayItem[] trayItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                TrayItem item = trayItemArray[n2];
                if (item != null) {
                    item.reskin(flags);
                }
                ++n2;
            }
        }
        super.reskinChildren(flags);
    }
}

