/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    NSScroller view;
    Scrollable parent;
    int minimum;
    int maximum = 100;
    int thumb = 10;
    int increment = 1;
    int pageIncrement = 10;
    id target;
    long actionSelector;

    ScrollBar() {
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    @Override
    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller widget = this.view;
        double value = widget.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * value + (double)this.minimum));
    }

    @Override
    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    @Override
    void sendSelection() {
        NSPoint point;
        NSWindow window = this.view.window();
        if (this.target == null) {
            this.parent.getShell().deferFlushing();
        }
        int value = 0;
        if (this.target != null) {
            this.view.sendAction(this.actionSelector, this.target);
        } else {
            value = this.getSelection();
        }
        NSEvent nsEvent = NSApplication.sharedApplication().currentEvent();
        if (nsEvent != null) {
            point = nsEvent.locationInWindow();
            if (nsEvent.window() == null) {
                point = window.convertScreenToBase(point);
            }
        } else {
            point = window.mouseLocationOutsideOfEventStream();
        }
        int hitPart = (int)this.view.testPart(point);
        Event event = new Event();
        switch (hitPart) {
            case 4: {
                value -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 1: {
                value -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                value += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                value += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (this.target == null && event.detail != 1) {
            this.setSelection(value);
        }
        this.sendSelectionEvent(13, event, true);
    }

    @Override
    void setClipRegion(NSView view) {
        this.parent.setClipRegion(view);
    }

    void enableWidget(boolean enabled) {
        if (!enabled || (this.state & 8) == 0) {
            this.view.setEnabled(enabled);
        }
    }

    public void setSelection(int selection) {
        this.checkWidget();
        this.updateBar(selection, this.minimum, this.maximum, this.thumb);
    }

    void updateBar(int selection, int minimum, int maximum, int thumb) {
        NSScroller widget = this.view;
        selection = Math.max(minimum, Math.min(maximum - thumb, selection));
        int range = maximum - thumb - minimum;
        float fraction = range <= 0 ? 1.0f : (float)(selection - minimum) / (float)range;
        float knob = range <= 0 ? 1.0f : (float)thumb / (float)(maximum - minimum);
        double oldFraction = widget.doubleValue();
        double oldKnob = widget.knobProportion();
        widget.setDoubleValue(fraction);
        widget.setKnobProportion(knob);
        widget.setEnabled(range > 0);
        if (this.target == null && ((double)knob != oldKnob || (double)fraction != oldFraction)) {
            this.parent.scrollView.flashScrollers();
        }
    }
}

