/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGradient;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Button
extends Control {
    String text;
    Image image;
    boolean grayed;
    private SWTView radioParent;
    private static final double[] DEFAULT_DISABLED_FOREGROUND = new double[]{0.6745f, 0.6745f, 0.6745f, 1.0};

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    @Override
    NSSize cellSizeForBounds(long id2, long sel, NSRect cellFrame) {
        NSCell cell;
        NSSize size = super.cellSizeForBounds(id2, sel, cellFrame);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize imageSize = this.image.handle.size();
            size.width += imageSize.width + 2.0;
            size.height = Math.max(size.height, imageSize.height);
        }
        if ((this.style & 0xA) != 0 && (this.style & 0x800040) == 0) {
            if (this.image != null && (cell = new NSCell(id2)).controlSize() == 1L) {
                size.height += 2.0;
            }
            size.width += 6.0;
        }
        if ((this.style & 0x40) != 0 && this.text.length() != 0 && cellFrame.width < 40000.0) {
            cell = new NSCell(id2);
            NSRect titleRect = cell.titleRectForBounds(cellFrame);
            NSSize wrapSize = new NSSize();
            wrapSize.width = titleRect.width;
            wrapSize.height = 40000.0;
            NSAttributedString attribStr = this.createString(this.text, null, this.foreground, this.style, true, true, true);
            NSRect rect = attribStr.boundingRectWithSize(wrapSize, 1L);
            attribStr.release();
            double trimHeight = Math.max(size.height - titleRect.height, 0.0);
            size.height = rect.height;
            if (this.image != null && (this.style & 0x30) != 0) {
                NSSize imageSize = this.image.handle.size();
                size.height = Math.max(size.height, imageSize.height);
            }
            size.height += trimHeight;
        }
        return size;
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        this.sendSelectionEvent(13);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int width = wHint != -1 ? wHint : 14;
            int height = hHint != -1 ? hHint : 14;
            return new Point(width, height);
        }
        NSSize size = null;
        NSCell cell = ((NSButton)this.view).cell();
        if ((this.style & 0x40) != 0 && wHint != -1) {
            NSRect rect = new NSRect();
            rect.width = wHint;
            rect.height = hHint != -1 ? hHint : 40000;
            size = cell.cellSizeForBounds(rect);
        } else {
            size = cell.cellSize();
        }
        int width = (int)Math.ceil(size.width);
        int height = (int)Math.ceil(size.height);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    NSAttributedString createString() {
        NSAttributedString attribStr = this.createString(this.text, null, this.foreground, this.style, false, true, true);
        attribStr.autorelease();
        return attribStr;
    }

    @Override
    void createHandle() {
        if ((this.style & 8) == 0) {
            this.state |= 0x800;
        }
        NSButton widget = (NSButton)new SWTButton().alloc();
        widget.init();
        NSButtonCell cell = (NSButtonCell)new SWTButtonCell().alloc().init();
        widget.setCell(cell);
        cell.release();
        if ((this.style & 0xA) != 0 && (this.style & 0x800000) == 0) {
            NSView superview = this.parent.view;
            while (superview != null) {
                if (superview.isKindOfClass(OS.class_NSTableView)) {
                    this.style |= 0x800000;
                    break;
                }
                superview = superview.superview();
            }
        }
        int type = 0;
        if ((this.style & 8) != 0) {
            if ((this.style & 0x800000) != 0) {
                widget.setBezelStyle(6L);
            } else {
                widget.setBezelStyle((this.style & 0x40) != 0 ? 2 : 1);
            }
        } else if ((this.style & 0x20) != 0) {
            type = 3;
        } else if ((this.style & 0x10) != 0) {
            type = 4;
            this.radioParent = (SWTView)new SWTView().alloc().init();
        } else if ((this.style & 2) != 0) {
            type = 1;
            if ((this.style & 0x800000) != 0) {
                widget.setBezelStyle(6L);
            } else {
                widget.setBezelStyle((this.style & 0x40) != 0 ? 2 : 1);
            }
        } else if ((this.style & 4) != 0) {
            widget.setBezelStyle(6L);
        }
        widget.setButtonType(type);
        widget.setTitle(NSString.string());
        widget.setImagePosition(2L);
        widget.setTarget(widget);
        widget.setAction(OS.sel_sendSelection);
        this.view = widget;
        this._setAlignment(this.style);
    }

    @Override
    void createWidget() {
        this.text = "";
        super.createWidget();
    }

    @Override
    Font defaultFont() {
        return Font.cocoa_new(this.display, this.defaultNSFont());
    }

    @Override
    NSFont defaultNSFont() {
        NSCell cell = ((NSControl)this.view).cell();
        return NSFont.systemFontOfSize(NSFont.systemFontSizeForControlSize(cell.controlSize()));
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
        if (this.radioParent != null) {
            this.display.removeWidget(this.radioParent);
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        boolean dragging;
        consume[0] = dragging = super.dragDetect(x, y, filter, consume);
        return dragging;
    }

    private static NSRect smallerRect(NSRect cellFrame, double dx, double dy1, double dy2, float lineWidth) {
        if (lineWidth == 2.0f) {
            dx -= 0.5;
            dy1 -= 0.5;
            dy2 -= 0.5;
        } else if ((double)lineWidth == 0.5) {
            dx += 0.25;
            dy1 += 0.25;
            dy2 += 0.25;
        } else if ((double)lineWidth == 0.75) {
            dx += 0.125;
            dy1 += 0.125;
            dy2 += 0.125;
        }
        NSRect result = new NSRect();
        result.x = cellFrame.x + dx;
        result.y = cellFrame.y + dy1;
        result.width = cellFrame.width - 2.0 * dx;
        result.height = cellFrame.height - dy1 - dy2;
        return result;
    }

    @Override
    void drawBezelWithFrame_inView(long id2, long sel, NSRect cellFrame, long viewid) {
        if (this.background != null) {
            NSBezierPath path;
            NSButton button = (NSButton)this.view;
            boolean isHighlighted = (this.style & 2) == 0 ? button.isHighlighted() : ((NSButton)this.view).state() == 1L;
            NSWindow window = button.window();
            NSButtonCell defaultButtonCell = window == null ? null : window.defaultButtonCell();
            boolean isDefault = defaultButtonCell != null && defaultButtonCell.id == id2;
            double[] borderRGB = Button.getLighterOrDarkerColor(this.background, 0.3, Button.luma(this.background) >= 0.5);
            if (isHighlighted && (this.style & 0x800000) != 0) {
                borderRGB = Button.getLighterOrDarkerColor(borderRGB, 0.2, true);
            }
            NSGraphicsContext gc = NSGraphicsContext.currentContext();
            gc.saveGraphicsState();
            float lineWidth = isDefault ? 2.0f : ((this.style & 0x800000) == 0 ? 0.75f : 1.0f);
            long bezelStyle = button.bezelStyle();
            if (bezelStyle == 1L) {
                rect2 = Button.smallerRect(cellFrame, 6.5, 4.5, 7.5, lineWidth);
                path = NSBezierPath.bezierPathWithRoundedRect(rect2, 3.0, 3.0);
            } else if (bezelStyle == 2L) {
                rect2 = Button.smallerRect(cellFrame, 2.5, 2.5, 3.5, lineWidth);
                path = NSBezierPath.bezierPathWithRoundedRect(rect2, 3.0, 3.0);
            } else {
                rect2 = Button.smallerRect(cellFrame, 0.5, 0.5, 0.5, lineWidth);
                path = NSBezierPath.bezierPathWithRect(rect2);
            }
            if (!isHighlighted) {
                double[] backgroundRGB = this.background;
                NSColor backgroundNSColor = NSColor.colorWithDeviceRed(backgroundRGB[0], backgroundRGB[1], backgroundRGB[2], 1.0);
                if ((this.style & 0x800000) == 0) {
                    double[] topRGB = Button.getLighterOrDarkerColor(this.background, 0.2, false);
                    NSColor topColor = NSColor.colorWithDeviceRed(topRGB[0], topRGB[1], topRGB[2], 1.0);
                    double[] bottomRGB = Button.getLighterOrDarkerColor(this.background, 0.1, true);
                    NSColor bottomColor = NSColor.colorWithDeviceRed(bottomRGB[0], bottomRGB[1], bottomRGB[2], 1.0);
                    NSMutableArray ma = NSMutableArray.arrayWithCapacity(4L);
                    ma.addObject(topColor);
                    ma.addObject(backgroundNSColor);
                    ma.addObject(backgroundNSColor);
                    ma.addObject(bottomColor);
                    NSGradient gradient = ((NSGradient)new NSGradient().alloc()).initWithColors(ma);
                    gradient.drawInBezierPath(path, 90.0);
                    gradient.release();
                } else {
                    backgroundNSColor.setFill();
                    path.fill();
                }
            } else {
                double[] colorRGB0 = Button.getLighterOrDarkerColor(this.background, 0.1f, true);
                NSColor color0 = NSColor.colorWithDeviceRed(colorRGB0[0], colorRGB0[1], colorRGB0[2], 1.0);
                color0.setFill();
                path.fill();
            }
            path.setLineWidth(lineWidth);
            NSColor borderNSColor = NSColor.colorWithDeviceRed(borderRGB[0], borderRGB[1], borderRGB[2], 1.0);
            borderNSColor.setStroke();
            path.stroke();
            gc.restoreGraphicsState();
            return;
        }
        super.drawBezelWithFrame_inView(id2, sel, cellFrame, viewid);
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellRect, long viewid) {
        if ((this.style & 0x30) != 0 && this.backgroundImage != null) {
            this.fillBackground(new NSView(viewid), NSGraphicsContext.currentContext(), cellRect, -1);
        }
        super.drawInteriorWithFrame_inView(id2, sel, cellRect, viewid);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize imageSize = this.image.handle.size();
            NSCell nsCell = new NSCell(id2);
            double x = 0.0;
            double y = (imageSize.height - cellRect.height) / 2.0;
            NSRect imageRect = nsCell.imageRectForBounds(cellRect);
            NSSize stringSize = ((NSButton)this.view).attributedTitle().size();
            switch (this.style & 0x1024000) {
                case 16384: {
                    x = imageRect.x + imageRect.width + 2.0;
                    break;
                }
                case 0x1000000: {
                    x = cellRect.x + imageRect.x + imageRect.width + (cellRect.width - stringSize.width) / 2.0 - imageSize.width - 2.0;
                    break;
                }
                case 131072: {
                    x = cellRect.x + cellRect.width - stringSize.width - imageSize.width - 2.0;
                }
            }
            NSRect destRect = new NSRect();
            destRect.x = x;
            destRect.y = y;
            destRect.width = imageSize.width;
            destRect.height = imageSize.height;
            NSGraphicsContext.static_saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.scaleXBy(1.0, -1.0);
            transform.translateXBy(0.0, -imageSize.height);
            transform.concat();
            this.image.handle.drawInRect(destRect, new NSRect(), 2L, 1.0);
            NSGraphicsContext.static_restoreGraphicsState();
        }
    }

    @Override
    NSRect drawTitleWithFrameInView(long id2, long sel, long title, NSRect titleRect, long view) {
        boolean wrap = (this.style & 0x40) != 0 && this.text.length() != 0;
        boolean isEnabled = this.isEnabled();
        if (wrap) {
            NSSize wrapSize = new NSSize();
            wrapSize.width = titleRect.width;
            wrapSize.height = 40000.0;
            double[] foreground2 = isEnabled ? (this.foreground == null ? this.display.getNSColorRGB(NSColor.textColor()) : this.foreground) : (this.foreground == null ? DEFAULT_DISABLED_FOREGROUND : Button.getLighterOrDarkerColor(this.foreground, 0.5, Button.luma(this.foreground) >= 0.5));
            NSAttributedString attribStr = this.createString(this.text, null, foreground2, this.style, true, true, true);
            NSRect rect = attribStr.boundingRectWithSize(wrapSize, 1L);
            switch (this.style & 0x1024000) {
                case 16384: {
                    rect.x = titleRect.x;
                    break;
                }
                case 0x1000000: {
                    rect.x = titleRect.x + (titleRect.width - rect.width) / 2.0;
                    break;
                }
                case 131072: {
                    rect.x = titleRect.x + titleRect.width - rect.width;
                }
            }
            rect.y = titleRect.y + (titleRect.height - rect.height) / 2.0;
            attribStr.drawInRect(rect);
            attribStr.release();
            return rect;
        }
        if (!isEnabled && this.foreground != null) {
            NSAttributedString attribStr = this.createString(this.text, null, Button.getLighterOrDarkerColor(this.foreground, 0.5, Button.luma(this.foreground) >= 0.5), this.style, false, true, true);
            NSRect result = super.drawTitleWithFrameInView(id2, sel, attribStr.id, titleRect, view);
            attribStr.release();
            return result;
        }
        return super.drawTitleWithFrameInView(id2, sel, title, titleRect, view);
    }

    @Override
    boolean drawsBackground() {
        return this.background != null || this.backgroundImage != null;
    }

    @Override
    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if ((this.style & 4) != 0) {
            NSRect frame = this.view.frame();
            int arrowSize = Math.min((int)frame.height, (int)frame.width) / 2;
            context.saveGraphicsState();
            NSPoint p1 = new NSPoint();
            p1.x = -arrowSize / 2;
            p1.y = -arrowSize / 2;
            NSPoint p2 = new NSPoint();
            p2.x = arrowSize / 2;
            p2.y = p1.y;
            NSPoint p3 = new NSPoint();
            p3.y = arrowSize / 2;
            NSBezierPath path = NSBezierPath.bezierPath();
            path.moveToPoint(p1);
            path.lineToPoint(p2);
            path.lineToPoint(p3);
            path.closePath();
            NSAffineTransform transform = NSAffineTransform.transform();
            if ((this.style & 0x4000) != 0) {
                transform.rotateByDegrees(90.0);
            } else if ((this.style & 0x80) != 0) {
                transform.rotateByDegrees(180.0);
            } else if ((this.style & 0x20000) != 0) {
                transform.rotateByDegrees(-90.0);
            }
            path.transformUsingAffineTransform(transform);
            transform = NSAffineTransform.transform();
            transform.translateXBy(frame.width / 2.0, frame.height / 2.0);
            path.transformUsingAffineTransform(transform);
            NSColor color = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
            color.set();
            path.fill();
            context.restoreGraphicsState();
        }
        super.drawWidget(id2, context, rect);
    }

    @Override
    NSRect focusRingMaskBoundsForFrame(long id2, long sel, NSRect cellFrame, long view) {
        return cellFrame;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        if ((this.style & 0x20) != 0 && this.grayed) {
            return ((NSButton)this.view).state() == -1L;
        }
        return ((NSButton)this.view).state() == 1L;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    long nextState(long id2, long sel) {
        if ((this.style & 0x20) != 0 && this.grayed) {
            return ((NSButton)this.view).state() == -1L ? 0 : -1;
        }
        return super.nextState(id2, sel);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
        if (this.radioParent != null) {
            this.display.addWidget(this.radioParent, this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.text = null;
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    @Override
    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            if (this.grayed && ((NSButton)this.view).state() == 1L) {
                ((NSButton)this.view).setState(0L);
            }
            if (!this.grayed && ((NSButton)this.view).state() == -1L) {
                ((NSButton)this.view).setState(1L);
            }
        }
        this.sendSelectionEvent(13);
    }

    void _setAlignment(int alignment) {
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        if (this.text != null) {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        Control control = this.findBackgroundControl();
        if (control == null || control.backgroundImage == null) {
            NSButtonCell cell = new NSButtonCell(((NSButton)this.view).cell());
            cell.setBackgroundColor(nsColor);
        }
    }

    @Override
    void setBackgroundImage(NSImage image) {
        if (image != null) {
            NSButtonCell cell = new NSButtonCell(((NSButton)this.view).cell());
            cell.setBackgroundColor(null);
        }
    }

    @Override
    void setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if ((this.style & 0xA) != 0 && (this.style & 0x800040) == 0) {
            int heightThreshold = 32;
            NSCell cell = ((NSControl)this.view).cell();
            if (cell != null && cell.controlSize() == 1L) {
                heightThreshold = 28;
            }
            NSButton button = (NSButton)this.view;
            if (height > heightThreshold) {
                button.setBezelStyle(2L);
            } else {
                button.setBezelStyle(1L);
            }
        }
        super.setBounds(x, y, width, height, move, resize);
        if (this.radioParent != null && resize) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            this.view.setFrameSize(size);
        }
    }

    @Override
    void setFont(NSFont font) {
        if (this.text != null) {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
    }

    @Override
    void setForeground(double[] color) {
        ((NSButton)this.view).setAttributedTitle(this.createString());
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        if ((this.style & 0x30) == 0) {
            ((NSButton)this.view).setImage(image != null ? image.handle : null);
            this.view.setNeedsDisplay(true);
        } else {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
        if (image != null && (this.style & 0xA) != 0 && (this.style & 0x800040) == 0) {
            NSCell cell = ((NSButton)this.view).cell();
            NSSize size = cell.cellSize();
            int height = (int)Math.ceil(size.height);
            if (height > 28) {
                cell.setControlSize(0L);
            } else if (this.display.smallFonts) {
                cell.setControlSize(1L);
            }
            this.setFont(this.getFont());
        }
        this.updateAlignment();
    }

    @Override
    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        if (this.grayed) {
            ((NSButton)this.view).setState(selected ? -1 : 0);
        } else {
            ((NSButton)this.view).setState(selected ? 1 : 0);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        ((NSButton)this.view).setAttributedTitle(this.createString());
        this.updateAlignment();
    }

    @Override
    NSRect titleRectForBounds(long id2, long sel, NSRect cellFrame) {
        NSRect rect = super.titleRectForBounds(id2, sel, cellFrame);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize imageSize = this.image.handle.size();
            rect.x += imageSize.width + 2.0;
            rect.width -= imageSize.width + 2.0;
            rect.width = Math.max(0.0, rect.width);
        }
        return rect;
    }

    @Override
    int traversalCode(int key, NSEvent theEvent) {
        int code = super.traversalCode(key, theEvent);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }

    void updateAlignment() {
        NSButton widget = (NSButton)this.view;
        if ((this.style & 0xA) != 0) {
            if (this.text.length() != 0 && this.image != null) {
                widget.setImagePosition(2L);
            } else {
                widget.setImagePosition(this.text.length() != 0 ? 0 : 1);
            }
        }
    }

    @Override
    NSView topView() {
        if (this.radioParent != null) {
            return this.radioParent;
        }
        return super.topView();
    }

    @Override
    void setZOrder() {
        super.setZOrder();
        if (this.radioParent != null) {
            this.radioParent.addSubview(this.view);
        }
    }
}

