/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public final class GridData {
    public int verticalAlignment = 2;
    public int horizontalAlignment = 1;
    public int widthHint = -1;
    public int heightHint = -1;
    public int horizontalIndent = 0;
    public int verticalIndent = 0;
    public int horizontalSpan = 1;
    public int verticalSpan = 1;
    public boolean grabExcessHorizontalSpace = false;
    public boolean grabExcessVerticalSpace = false;
    public int minimumWidth = 0;
    public int minimumHeight = 0;
    public boolean exclude = false;
    int cacheWidth = -1;
    int cacheHeight = -1;
    int defaultWhint;
    int defaultHhint;
    int defaultWidth = -1;
    int defaultHeight = -1;
    int currentWhint;
    int currentHhint;
    int currentWidth = -1;
    int currentHeight = -1;

    public GridData() {
    }

    public GridData(int style) {
        if ((style & 2) != 0) {
            this.verticalAlignment = 1;
        }
        if ((style & 4) != 0) {
            this.verticalAlignment = 2;
        }
        if ((style & 0x10) != 0) {
            this.verticalAlignment = 4;
        }
        if ((style & 8) != 0) {
            this.verticalAlignment = 3;
        }
        if ((style & 0x20) != 0) {
            this.horizontalAlignment = 1;
        }
        if ((style & 0x40) != 0) {
            this.horizontalAlignment = 2;
        }
        if ((style & 0x100) != 0) {
            this.horizontalAlignment = 4;
        }
        if ((style & 0x80) != 0) {
            this.horizontalAlignment = 3;
        }
        this.grabExcessHorizontalSpace = (style & 0x200) != 0;
        this.grabExcessVerticalSpace = (style & 0x400) != 0;
    }

    public GridData(int width, int height) {
        this.widthHint = width;
        this.heightHint = height;
    }

    void computeSize(Control control, int wHint, int hHint, boolean flushCache) {
        if (this.cacheWidth != -1 && this.cacheHeight != -1) {
            return;
        }
        if (wHint == this.widthHint && hHint == this.heightHint) {
            if (this.defaultWidth == -1 || this.defaultHeight == -1 || wHint != this.defaultWhint || hHint != this.defaultHhint) {
                Point size = control.computeSize(wHint, hHint, flushCache);
                this.defaultWhint = wHint;
                this.defaultHhint = hHint;
                this.defaultWidth = size.x;
                this.defaultHeight = size.y;
            }
            this.cacheWidth = this.defaultWidth;
            this.cacheHeight = this.defaultHeight;
            return;
        }
        if (this.currentWidth == -1 || this.currentHeight == -1 || wHint != this.currentWhint || hHint != this.currentHhint) {
            Point size = control.computeSize(wHint, hHint, flushCache);
            this.currentWhint = wHint;
            this.currentHhint = hHint;
            this.currentWidth = size.x;
            this.currentHeight = size.y;
        }
        this.cacheWidth = this.currentWidth;
        this.cacheHeight = this.currentHeight;
    }

    void flushCache() {
        this.cacheHeight = -1;
        this.cacheWidth = -1;
        this.defaultHeight = -1;
        this.defaultWidth = -1;
        this.currentHeight = -1;
        this.currentWidth = -1;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        String hAlign = "";
        hAlign = switch (this.horizontalAlignment) {
            case 4 -> "SWT.FILL";
            case 1 -> "SWT.BEGINNING";
            case 16384 -> "SWT.LEFT";
            case 0x1000008 -> "SWT.END";
            case 3 -> "GridData.END";
            case 131072 -> "SWT.RIGHT";
            case 0x1000000 -> "SWT.CENTER";
            case 2 -> "GridData.CENTER";
            default -> "Undefined " + this.horizontalAlignment;
        };
        String vAlign = "";
        vAlign = switch (this.verticalAlignment) {
            case 4 -> "SWT.FILL";
            case 1 -> "SWT.BEGINNING";
            case 128 -> "SWT.TOP";
            case 0x1000008 -> "SWT.END";
            case 3 -> "GridData.END";
            case 1024 -> "SWT.BOTTOM";
            case 0x1000000 -> "SWT.CENTER";
            case 2 -> "GridData.CENTER";
            default -> "Undefined " + this.verticalAlignment;
        };
        Object string = this.getName() + " {";
        string = (String)string + "horizontalAlignment=" + hAlign + " ";
        if (this.horizontalIndent != 0) {
            string = (String)string + "horizontalIndent=" + this.horizontalIndent + " ";
        }
        if (this.horizontalSpan != 1) {
            string = (String)string + "horizontalSpan=" + this.horizontalSpan + " ";
        }
        if (this.grabExcessHorizontalSpace) {
            string = (String)string + "grabExcessHorizontalSpace=" + this.grabExcessHorizontalSpace + " ";
        }
        if (this.widthHint != -1) {
            string = (String)string + "widthHint=" + this.widthHint + " ";
        }
        if (this.minimumWidth != 0) {
            string = (String)string + "minimumWidth=" + this.minimumWidth + " ";
        }
        string = (String)string + "verticalAlignment=" + vAlign + " ";
        if (this.verticalIndent != 0) {
            string = (String)string + "verticalIndent=" + this.verticalIndent + " ";
        }
        if (this.verticalSpan != 1) {
            string = (String)string + "verticalSpan=" + this.verticalSpan + " ";
        }
        if (this.grabExcessVerticalSpace) {
            string = (String)string + "grabExcessVerticalSpace=" + this.grabExcessVerticalSpace + " ";
        }
        if (this.heightHint != -1) {
            string = (String)string + "heightHint=" + this.heightHint + " ";
        }
        if (this.minimumHeight != 0) {
            string = (String)string + "minimumHeight=" + this.minimumHeight + " ";
        }
        if (this.exclude) {
            string = (String)string + "exclude=" + this.exclude + " ";
        }
        string = ((String)string).trim();
        string = (String)string + "}";
        return string;
    }
}

