/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PNGFileFormat;
import org.eclipse.swt.internal.image.WinBMPFileFormat;

public final class WinICOFileFormat
extends FileFormat {
    byte[] bitInvertData(byte[] data, int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex) {
            data[i] = (byte)(255 - data[i - startIndex]);
            ++i;
        }
        return data;
    }

    static byte[] convertPad(byte[] data, int width, int height, int depth, int pad, int newPad) {
        if (pad == newPad) {
            return data;
        }
        int stride = (width * depth + 7) / 8;
        int bpl = (stride + (pad - 1)) / pad * pad;
        int newBpl = (stride + (newPad - 1)) / newPad * newPad;
        byte[] newData = new byte[height * newBpl];
        int srcIndex = 0;
        int destIndex = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(data, srcIndex, newData, destIndex, newBpl);
            srcIndex += bpl;
            destIndex += newBpl;
            ++y;
        }
        return newData;
    }

    @Override
    boolean isFileFormat(LEDataInputStream stream) {
        try {
            byte[] header = new byte[4];
            stream.read(header);
            stream.unread(header);
            return header[0] == 0 && header[1] == 0 && header[2] == 1 && header[3] == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    int loadFileHeader(LEDataInputStream byteStream) {
        int numIcons;
        int[] fileHeader = new int[3];
        try {
            fileHeader[0] = byteStream.readShort();
            fileHeader[1] = byteStream.readShort();
            fileHeader[2] = byteStream.readShort();
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        if (fileHeader[0] != 0 || fileHeader[1] != 1) {
            SWT.error(40);
        }
        if ((numIcons = fileHeader[2]) <= 0) {
            SWT.error(40);
        }
        return numIcons;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int numIcons = this.loadFileHeader(this.inputStream);
        int[][] headers = this.loadIconHeaders(numIcons);
        ImageData[] icons = new ImageData[headers.length];
        int i = 0;
        while (i < icons.length) {
            icons[i] = this.loadIcon(headers[i]);
            ++i;
        }
        return icons;
    }

    ImageData loadIcon(int[] iconHeader) {
        try {
            PNGFileFormat png = new PNGFileFormat();
            if (((FileFormat)png).isFileFormat(this.inputStream)) {
                png.loader = this.loader;
                return png.loadFromStream(this.inputStream)[0];
            }
        }
        catch (Exception png) {
            // empty catch block
        }
        byte[] infoHeader = this.loadInfoHeader(iconHeader);
        WinBMPFileFormat bmpFormat = new WinBMPFileFormat();
        bmpFormat.inputStream = this.inputStream;
        PaletteData palette = bmpFormat.loadPalette(infoHeader);
        byte[] shapeData = bmpFormat.loadData(infoHeader);
        int width = infoHeader[4] & 0xFF | (infoHeader[5] & 0xFF) << 8 | (infoHeader[6] & 0xFF) << 16 | (infoHeader[7] & 0xFF) << 24;
        int height = infoHeader[8] & 0xFF | (infoHeader[9] & 0xFF) << 8 | (infoHeader[10] & 0xFF) << 16 | (infoHeader[11] & 0xFF) << 24;
        if (height < 0) {
            height = -height;
        }
        int depth = infoHeader[14] & 0xFF | (infoHeader[15] & 0xFF) << 8;
        infoHeader[14] = 1;
        infoHeader[15] = 0;
        byte[] maskData = bmpFormat.loadData(infoHeader);
        maskData = WinICOFileFormat.convertPad(maskData, width, height, 1, 4, 2);
        this.bitInvertData(maskData, 0, maskData.length);
        return ImageData.internal_new(width, height, depth, palette, 4, shapeData, 2, maskData, null, -1, -1, 3, 0, 0, 0, 0);
    }

    int[][] loadIconHeaders(int numIcons) {
        int[][] headers = new int[numIcons][7];
        try {
            int i = 0;
            while (i < numIcons) {
                headers[i][0] = this.inputStream.read();
                headers[i][1] = this.inputStream.read();
                headers[i][2] = this.inputStream.readShort();
                headers[i][3] = this.inputStream.readShort();
                headers[i][4] = this.inputStream.readShort();
                headers[i][5] = this.inputStream.readInt();
                headers[i][6] = this.inputStream.readInt();
                ++i;
            }
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        return headers;
    }

    byte[] loadInfoHeader(int[] iconHeader) {
        int width = iconHeader[0];
        int height = iconHeader[1];
        int numColors = iconHeader[2];
        if (numColors == 0) {
            numColors = 256;
        }
        if (numColors != 2 && numColors != 8 && numColors != 16 && numColors != 32 && numColors != 256) {
            SWT.error(40);
        }
        if (this.inputStream.getPosition() < iconHeader[6]) {
            try {
                this.inputStream.skip(iconHeader[6] - this.inputStream.getPosition());
            }
            catch (IOException e) {
                SWT.error(39, e);
                return null;
            }
        }
        byte[] infoHeader = new byte[40];
        try {
            this.inputStream.read(infoHeader);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        if ((infoHeader[12] & 0xFF | (infoHeader[13] & 0xFF) << 8) != 1) {
            SWT.error(40);
        }
        int infoWidth = infoHeader[4] & 0xFF | (infoHeader[5] & 0xFF) << 8 | (infoHeader[6] & 0xFF) << 16 | (infoHeader[7] & 0xFF) << 24;
        int infoHeight = infoHeader[8] & 0xFF | (infoHeader[9] & 0xFF) << 8 | (infoHeader[10] & 0xFF) << 16 | (infoHeader[11] & 0xFF) << 24;
        int bitCount = infoHeader[14] & 0xFF | (infoHeader[15] & 0xFF) << 8;
        if (width == 0) {
            width = infoWidth;
        }
        if (height == 0) {
            height = infoHeight / 2;
        }
        if (height == infoHeight && bitCount == 1) {
            height /= 2;
        }
        if (width != infoWidth || height * 2 != infoHeight || bitCount != 1 && bitCount != 4 && bitCount != 8 && bitCount != 24 && bitCount != 32) {
            SWT.error(40);
        }
        infoHeader[8] = (byte)(height & 0xFF);
        infoHeader[9] = (byte)(height >> 8 & 0xFF);
        infoHeader[10] = (byte)(height >> 16 & 0xFF);
        infoHeader[11] = (byte)(height >> 24 & 0xFF);
        return infoHeader;
    }
}

