/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static AutoScaleMethod autoScaleMethodSetting = AutoScaleMethod.AUTO;
    private static AutoScaleMethod autoScaleMethod = AutoScaleMethod.NEAREST;
    private static String autoScaleValue;
    private static boolean useCairoAutoScale;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";
    private static final String SWT_AUTOSCALE_UPDATE_ON_RUNTIME = "swt.autoScale.updateOnRuntime";

    static {
        useCairoAutoScale = false;
        autoScaleValue = System.getProperty(SWT_AUTOSCALE);
        String value = System.getProperty(SWT_AUTOSCALE_METHOD);
        if (value != null) {
            if (AutoScaleMethod.NEAREST.name().equalsIgnoreCase(value)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.NEAREST;
            } else if (AutoScaleMethod.SMOOTH.name().equalsIgnoreCase(value)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.SMOOTH;
            }
        }
    }

    public static int autoScaleDown(int size) {
        return DPIUtil.scaleDown(size, deviceZoom);
    }

    public static int scaleDown(int size, int zoom) {
        if (zoom == 100 || size == -1) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return Math.round((float)size / scaleFactor);
    }

    public static float autoScaleDown(float size) {
        return DPIUtil.scaleDown(size, deviceZoom);
    }

    public static float scaleDown(float size, int zoom) {
        if (zoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return size / scaleFactor;
    }

    public static ImageData scaleImageData(Device device, ImageData imageData, int targetZoom, int currentZoom) {
        if (imageData == null || targetZoom == currentZoom || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    private static ImageData autoScaleImageData(Device device, ImageData imageData, float scaleFactor) {
        boolean useSmoothScaling;
        int width = imageData.width;
        int height = imageData.height;
        int scaledWidth = Math.round((float)width * scaleFactor);
        int scaledHeight = Math.round((float)height * scaleFactor);
        boolean bl = useSmoothScaling = autoScaleMethod == AutoScaleMethod.SMOOTH && imageData.getTransparencyType() != 2;
        if (useSmoothScaling) {
            Image original = new Image(device, zoom -> imageData);
            ImageData resultData = new ImageData(scaledWidth, scaledHeight, 24, new PaletteData(255, 65280, 0xFF0000));
            resultData.alphaData = new byte[scaledWidth * scaledHeight];
            Image resultImage = new Image(device, zoom -> resultData);
            GC gc = new GC(resultImage);
            gc.setAntialias(1);
            gc.drawImage(original, 0, 0, DPIUtil.autoScaleDown(width), DPIUtil.autoScaleDown(height), 0, 0, Math.round(DPIUtil.autoScaleDown((float)width * scaleFactor)), Math.round(DPIUtil.autoScaleDown((float)height * scaleFactor)));
            gc.dispose();
            original.dispose();
            ImageData result = resultImage.getImageData(DPIUtil.getDeviceZoom());
            resultImage.dispose();
            return result;
        }
        return imageData.scaledTo(scaledWidth, scaledHeight);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int imageDataZoomFactor) {
        if (deviceZoom == imageDataZoomFactor || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)deviceZoom / (float)imageDataZoomFactor;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        return DPIUtil.autoScaleImageData(device, imageData, 100);
    }

    private static float getScalingFactor(int zoom) {
        if (useCairoAutoScale) {
            return 1.0f;
        }
        if (zoom <= 0) {
            zoom = deviceZoom;
        }
        return (float)zoom / 100.0f;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int nativeDeviceZoom) {
        boolean preserveScalingMethod;
        int deviceZoom;
        DPIUtil.nativeDeviceZoom = nativeDeviceZoom;
        DPIUtil.deviceZoom = deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(deviceZoom));
        boolean bl = preserveScalingMethod = SWT.getPlatform().equals("gtk") && deviceZoom == 100;
        if (!preserveScalingMethod && autoScaleMethodSetting == AutoScaleMethod.AUTO) {
            autoScaleMethod = DPIUtil.sholdUseSmoothScaling() ? AutoScaleMethod.SMOOTH : AutoScaleMethod.NEAREST;
        }
    }

    private static boolean sholdUseSmoothScaling() {
        return switch (SWT.getPlatform()) {
            case "gtk" -> {
                if (deviceZoom / 100 * 100 != deviceZoom) {
                    yield true;
                }
                yield false;
            }
            case "win32" -> DPIUtil.isMonitorSpecificScalingActive();
            default -> false;
        };
    }

    public static int getZoomForAutoscaleProperty(int nativeDeviceZoom) {
        int zoom = 0;
        if (autoScaleValue != null) {
            if ("false".equalsIgnoreCase(autoScaleValue)) {
                zoom = 100;
            } else if ("half".equalsIgnoreCase(autoScaleValue)) {
                zoom = (int)Math.rint((double)nativeDeviceZoom / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(autoScaleValue)) {
                zoom = Math.round((float)nativeDeviceZoom / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(autoScaleValue)) {
                zoom = nativeDeviceZoom;
            } else {
                try {
                    int zoomValue = Integer.parseInt(autoScaleValue);
                    zoom = Math.max(Math.min(zoomValue, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (zoom == 0) {
            zoom = Math.max((nativeDeviceZoom + 25) / 100 * 100, 100);
        }
        return zoom;
    }

    public static boolean isMonitorSpecificScalingActive() {
        boolean updateOnRuntimeValue = Boolean.getBoolean(SWT_AUTOSCALE_UPDATE_ON_RUNTIME);
        return updateOnRuntimeValue;
    }

    private static final class AutoScaleMethod
    extends Enum<AutoScaleMethod> {
        public static final /* enum */ AutoScaleMethod AUTO = new AutoScaleMethod();
        public static final /* enum */ AutoScaleMethod NEAREST = new AutoScaleMethod();
        public static final /* enum */ AutoScaleMethod SMOOTH = new AutoScaleMethod();
        private static final /* synthetic */ AutoScaleMethod[] ENUM$VALUES;

        static {
            ENUM$VALUES = new AutoScaleMethod[]{AUTO, NEAREST, SMOOTH};
        }
    }
}

