/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    public String name;
    public float height;
    public int style;
    public String nsName;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String name, int height, int style) {
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
    }

    FontData(String name, float height, int style) {
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void data;
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fontData = (FontData)object;
        return this.name.equals(data.name) && this.height == data.height && this.style == data.style;
    }

    public int getHeight() {
        return (int)this.height;
    }

    float getHeightF() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.getHeight() << 8 ^ this.style;
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.height = height;
    }

    void setHeight(float height) {
        if (height < 0.0f) {
            SWT.error(5);
        }
        this.height = height;
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        this.name = name;
        this.nsName = null;
    }

    public void setStyle(int style) {
        this.style = style;
        this.nsName = null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeightF());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        buffer.append("COCOA|1|");
        if (this.nsName != null) {
            buffer.append(this.nsName);
        }
        return buffer.toString();
    }
}

