/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import java.util.List;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.fetchers.FetcherRegistryUpdateListener;
import net.azib.ipscan.gui.actions.ColumnsActions;
import net.azib.ipscan.gui.actions.CommandsMenuActions;
import net.azib.ipscan.gui.actions.ToolsActions;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ResultTable
extends Table
implements StateTransitionListener,
FetcherRegistryUpdateListener {
    private ScanningResultList scanningResults;
    private GUIConfig guiConfig;
    private FetcherRegistry fetcherRegistry;
    private Image[] listImages = new Image[ScanningResult.ResultType.values().length];
    private Listener columnClickListener;
    private Listener columnResizeListener;

    public ResultTable(Shell parent, GUIConfig guiConfig, FetcherRegistry fetcherRegistry, ScanningResultList scanningResultList, StateMachine stateMachine, ColumnsActions.ColumnClick columnClickListener, ColumnsActions.ColumnResize columnResizeListener) {
        super(parent, 268503042);
        this.guiConfig = guiConfig;
        this.scanningResults = scanningResultList;
        this.fetcherRegistry = fetcherRegistry;
        this.setHeaderVisible(true);
        this.setLinesVisible(true);
        this.columnClickListener = columnClickListener;
        this.columnResizeListener = columnResizeListener;
        fetcherRegistry.addListener(this);
        this.handleUpdateOfSelectedFetchers(fetcherRegistry);
        this.listImages[ScanningResult.ResultType.UNKNOWN.ordinal()] = LayoutHelper.icon("list/unknown");
        this.listImages[ScanningResult.ResultType.DEAD.ordinal()] = LayoutHelper.icon("list/dead");
        this.listImages[ScanningResult.ResultType.ALIVE.ordinal()] = LayoutHelper.icon("list/alive");
        this.listImages[ScanningResult.ResultType.WITH_PORTS.ordinal()] = LayoutHelper.icon("list/ports");
        this.addListener(1, new CommandsMenuActions.Delete(this, stateMachine));
        this.addListener(1, new CommandsMenuActions.CopyIP(this));
        this.addListener(1, new ToolsActions.SelectAll(this));
        this.addListener(36, new SetDataListener());
        stateMachine.addTransitionListener(this);
    }

    @Override
    public void handleUpdateOfSelectedFetchers(FetcherRegistry fetcherRegistry) {
        this.removeAll();
        for (TableColumn column : this.getColumns()) {
            column.dispose();
        }
        for (Fetcher fetcher : fetcherRegistry.getSelectedFetchers()) {
            TableColumn tableColumn = new TableColumn(this, 0);
            tableColumn.setWidth(this.guiConfig.getColumnWidth(fetcher));
            tableColumn.setData(fetcher);
            tableColumn.addListener(13, this.columnClickListener);
            tableColumn.addListener(11, this.columnResizeListener);
        }
        this.updateColumnNames();
    }

    public void updateColumnNames() {
        int i = 0;
        for (Fetcher fetcher : this.fetcherRegistry.getSelectedFetchers()) {
            this.getColumn(i++).setText(fetcher.getFullName());
        }
    }

    @Override
    protected void checkSubclass() {
    }

    public void addOrUpdateResultRow(ScanningResult result) {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.scanningResults.isRegistered(result)) {
                int index = this.scanningResults.update(result);
                this.clear(index);
            } else {
                int index = this.getItemCount();
                this.scanningResults.registerAtIndex(index, result);
                new TableItem(this, 0);
            }
        });
    }

    public void updateResults() {
        this.clearAll();
    }

    public void updateResult(int index, String fetcherId, Object newValue) {
        int fetcherIndex = this.scanningResults.getFetcherIndex(fetcherId);
        if (fetcherIndex >= 0) {
            this.scanningResults.getResult(index).setValue(fetcherIndex, newValue);
            this.clear(index);
        }
    }

    public ScanningResult getSelectedResult() {
        int selectedIndex = this.getSelectionIndex();
        return this.scanningResults.getResult(selectedIndex);
    }

    @Override
    public void remove(int[] indices) {
        this.scanningResults.remove(indices);
        super.remove(indices);
    }

    @Override
    public void removeAll() {
        this.scanningResults.clear();
        super.removeAll();
        this.setSortColumn(null);
    }

    public void resetSelection() {
        int[] selectionIndices;
        for (int itemNum : selectionIndices = this.getSelectionIndices()) {
            this.scanningResults.getResult(itemNum).reset();
        }
        this.clear(selectionIndices);
    }

    public ScanningResultList getScanningResults() {
        return this.scanningResults;
    }

    @Override
    public void transitionTo(ScanningState state, StateMachine.Transition transition) {
        this.setCursor(this.getDisplay().getSystemCursor(state == ScanningState.IDLE ? 0 : 3));
    }

    final class SetDataListener
    implements Listener {
        SetDataListener() {
        }

        @Override
        public void handleEvent(Event event) {
            TableItem item = (TableItem)event.item;
            int tableIndex = ResultTable.this.indexOf(item);
            if (tableIndex < 0) {
                return;
            }
            ScanningResult scanningResult = ResultTable.this.scanningResults.getResult(tableIndex);
            List<Object> values = scanningResult.getValues();
            String[] resultStrings = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                if (value == null) continue;
                resultStrings[i] = value.toString();
            }
            item.setText(resultStrings);
            item.setImage(0, ResultTable.this.listImages[scanningResult.getType().ordinal()]);
        }
    }
}

