/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.fetchers.UnixMACFetcher;

public class LinuxMACFetcher
extends MACFetcher {
    private static final Path ARP_TABLE = Path.of("/proc/net/arp", new String[0]);
    private int flagsIndex;
    private int macIndex;
    private int macLength = 17;

    public LinuxMACFetcher() {
        String line = LinuxMACFetcher.arpLines().findFirst().get();
        this.flagsIndex = line.indexOf("Flags");
        this.macIndex = line.indexOf("HW addr");
    }

    private static Stream<String> arpLines() {
        try {
            return Files.lines(ARP_TABLE);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public String resolveMAC(ScanningSubject subject) {
        try {
            String ip = subject.getAddress().getHostAddress();
            return LinuxMACFetcher.arpLines().filter(line -> line.startsWith(ip + " ") && !line.substring(this.flagsIndex, this.flagsIndex + 3).equals("0x0")).findFirst().map(line -> line.substring(this.macIndex, this.macIndex + this.macLength).toUpperCase()).orElse(UnixMACFetcher.getLocalMAC(subject));
        }
        catch (Exception e) {
            return null;
        }
    }
}

