/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.azib.ipscan.config.LoggerFactory;

public class Version {
    private static String version;
    private static String buildDate;

    public static String getVersion() {
        if (version == null) {
            Version.loadVersionFromJar();
        }
        return version;
    }

    public static String getBuildDate() {
        if (buildDate == null) {
            Version.loadVersionFromJar();
        }
        return buildDate;
    }

    private static void loadVersionFromJar() {
        try {
            String path = Version.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (path.endsWith(".jar") || path.endsWith(".exe")) {
                JarFile jarFile = new JarFile(path);
                Attributes attrs = jarFile.getManifest().getMainAttributes();
                version = attrs.getValue("Version");
                buildDate = attrs.getValue("Build-Date");
                return;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger().log(Level.WARNING, "Cannot obtain version", e);
        }
        version = "current";
        buildDate = "today";
    }

    public static String getFullName() {
        return "Angry IP Scanner " + Version.getVersion();
    }
}

