(function(){window.sendMessageToCloudGame=sendMessageToCloudGame;window.sendMessageFromCloudGameCallback=sendMessageFromCloudGameCallback})();let command="";let seq=0;let sdk=1;let lastX=null;let lastY=null;let zegoPlatform=getLocationPlatform();function sendMessageToCloudGame(message){try{const msg=JSON.parse(message);command=msg.command;seq=msg.seq;switch(msg.command){case"zego_cloud_game_init":sdk=msg.data.cloudType;init(msg.data.appid);break;case"zego_cloud_game_start":start(msg.data);break;case"zego_cloud_game_destroy":destroy();break;case"zego_cloud_game_set_stream_profile":setStreamProfile(msg.data);break;case"zego_cloud_game_set_video_volume":setVideoVolume(msg.data);break;case"zego_cloud_game_send_keyboard_event":sendKeyboardEvent(msg.data.key);break;case"zego_cloud_game_video_volume":getVideoVolume();break}}catch(err){console.warn("sendMessageToCloudGame err",err)}}function sendMessageFromCloudGameCallback(message){console.log("sendMessageFromCloudGameCallback",message)}async function init(appid){switch(sdk){case 1:{createParentContainer("mount-point");TCGSDK.init({appid:appid,mount:"mount-point",defaultCursorImgUrl:"",debugSetting:{showLog:true},loadingText:"",onConnectSuccess:async res=>{console.log("======onConnectSuccess",res)},onConnectFail:async res=>{console.log("onConnectFail",res);if(res.code===-3){res.code=8210010}else if(res.code===-2){res.code=8210011}else if(res.code===-1){res.code=8210012}else{res.code=8210013}errCallback(res)},onDisconnect:res=>{if(res.code===0){const postData={command:"zego_cloud_game_destroy",seq:seq,data:{...res}};sendMessageToNative(postData)}else{if(res.code===-2){res.code=8210020}else if(res.code===-1){res.code=8210021}else if(res.code===1){res.code=8210022}else if(res.code===2){res.code=8210023}errCallback(res)}},onWebrtcStatusChange:res=>{if(res.code===0){const postData={command:"zego_cloud_game_start",seq:seq,data:{code:0,msg:"start game success!"}};sendMessageToNative(postData)}else{if(res.code===-2){res.code=8210030}else if(res.code===-1){res.code=8210031}else if(res.code===1){res.code=8210032}else if(res.code===2){res.code=8210033}else if(res.code===3){res.code=8210034}else if(res.code===4){res.code=8210035}else if(res.code===5){res.code=8210036}else if(res.code===6){res.code=8210037}else if(res.code===7){res.code=8210038}else if(res.code===100){res.code=8210039}else if(res.code===225){res.code=8210040}errCallback(res)}},onTouchEvent:async res=>{if(res.length===1){const{id,type,pageX,pageY}=res.pop();TCGSDK.mouseMove(id,type,pageX,pageY);if(type==="touchstart"){TCGSDK.sendMouseEvent({type:"mouseleft",down:true})}if(type==="touchend"||type==="touchcancel"){TCGSDK.sendMouseEvent({type:"mouseleft",down:false})}}if(res.length===2){const[{pageX:oneX,pageY:oneY},{pageX:twoX,pageY:twoY}]=res;const currentX=Math.ceil(Math.abs(oneX-twoX));const currentY=Math.ceil(Math.abs(oneY-twoY));lastX||(lastX=currentX);lastY||(lastY=currentY);if(lastX&&currentX-lastX<0&&lastY&&currentY-lastY<0){TCGSDK.sendMouseEvent({type:"mousescroll",delta:1});lastX=currentX;lastY=currentY}if(lastX&&currentX-lastX>0&&lastY&&currentY-lastY>0){TCGSDK.sendMouseEvent({type:"mousescroll",delta:-1});lastX=currentX;lastY=currentY}}},onInitSuccess:async res=>{console.log("======onInitSuccess",res);if(res.code===0){const clientSession=TCGSDK.getClientSession();initRespond({code:0,msg:"ok",clientSession:clientSession,bizData:"",node:""})}else if(res.code===-1){res.code=8210050;initRespond(res)}},onEvent:async res=>{if(res.type==="autoplay"){const postData={command:"zego_cloud_game_first_frame",data:{code:8210001,msg:"first frame rendering successful!"}};sendSDKCallbackToNative(postData)}}});break}case 4:{createParentContainer("gameVideo");const{width,height}=document.querySelector("body").getBoundingClientRect();const gameConfig={id:"gameVideo",videoWidth:width||1,videoHeight:height||1,videoPoster:"",IspUrl:"https://jpaas-ks.vlinkcloud.net",mouseShortcut:192,lockPoint:false,enableClipBoard:true,rotate:0,tenantKey:"1710947139900805121"};console.warn("gameConfig",gameConfig.videoWidth,gameConfig.videoHeight,width,height);window.WLCG=WLCG=new WelinkCloudGame(gameConfig);registerWlCallback();window.WLCG.init();const bizData=WLCG.getBizData();await getNode().then(node=>{initRespond({code:0,msg:"ok",clientSession:"",bizData:bizData,node:node})});break}}}function initRespond(res){const postData={command:"zego_cloud_game_init",seq:seq,data:{...res}};sendMessageToNative(postData)}async function getNode(){return new Promise((resolve,reject)=>{WLCG.getNode(result=>{if(result){resolve(result.nodeResult.nodeId)}else{resolve("1001994")}},err=>{console.log("get node err",err);resolve("1001994")})})}async function start(data){switch(sdk){case 1:{TCGSDK.start(data.serverSession);break}case 4:{WLCG.startGame(data.sdkMsg);break}}}function destroy(){switch(sdk){case 1:console.log("===destroy",sdk,TCGSDK.getInitOptions().mount);if(TCGSDK.getInitOptions().mount){TCGSDK.destroy()}else{destroyRespond(command,821e4,"SDK 未初始化")}break;case 4:try{WLCG.exitGame();destroyRespond(command,0,"主动关闭")}catch(err){destroyRespond(command,821e4,"SDK 未初始化")}break}}function destroyRespond(command,code,msg){console.log("===destroy",command,code,msg);const postData={command:command,seq:seq,data:{code:code,msg:msg}};sendMessageToNative(postData)}function sendKeyboardEvent(key){switch(sdk){case 1:{TCGSDK.sendKeyboardEvent({key:key,down:true});setTimeout(()=>{TCGSDK.sendKeyboardEvent({key:key,down:false})},200);break}case 4:{WLCG.onKeyBoardEvent(key,WLCG.KEY_DOWN);setTimeout(()=>{WLCG.onKeyBoardEvent(key,WLCG.KEY_UP)},200);break}}}function setStreamProfile(data){TCGSDK.setStreamProfile(data)}function setVideoVolume(data){TCGSDK.setVideoVolume(data.value);const value=data.value;const postData={command:"zego_cloud_game_set_video_volume",seq:seq,data:{value:value,msg:"设置成功"}};sendMessageToNative(postData)}function getVideoVolume(){const value=TCGSDK.getVideoVolume();console.log("getVideoVolume",value);const postData={command:"zego_cloud_game_video_volume",seq:seq,data:{value:value}};sendMessageToNative(postData)}function setRemoteDesktopResolution(data){switch(sdk){case 1:{TCGSDK.setRemoteDesktopResolution({width:data.width,height:data.height}).then(res=>{const postData={command:"zego_cloud_game_set_resolution",seq:seq,data:{...res}};sendMessageToNative(postData)});break}case 4:{break}}}function errCallback(data){const postData={command:"zego_cloud_game_err",data:{...data}};sendSDKCallbackToNative(postData)}function sendMessageToNative(data){try{if(zegoPlatform==="ios"){window.webkit.messageHandlers.onSendMessageToCloudGameCallback.postMessage(JSON.stringify(data))}else if(zegoPlatform==="android"){window.zegocloudgame.onSendMessageToCloudGameCallback(JSON.stringify(data))}else{data.type="onSendMessageToCloudGameCallback";window.parent.postMessage(JSON.stringify(data))}}catch(err){console.log("sendMessageToNative err",err)}}function sendSDKCallbackToNative(data){try{if(zegoPlatform==="ios"){window.webkit.messageHandlers.onMessageFromCloudGame.postMessage(JSON.stringify(data))}else if(zegoPlatform==="android"){window.zegocloudgame.onMessageFromCloudGame(JSON.stringify(data))}else{data.type="onMessageFromCloudGame";window.parent.postMessage(JSON.stringify(data))}}catch(err){console.log("sendSDKCallbackToNative err",err)}}function registerWlCallback(){WLCG.startGameInfo=(code,message)=>{console.warn(`${(new Date).toTimeString().split(" ")[0]} - wl startGameInfo`,code,message);if(code===6038){const postData={command:"zego_cloud_game_start",seq:seq,data:{code:0,msg:"start game success!"}};sendMessageToNative(postData);const callbackData={command:"zego_cloud_game_first_frame",data:{code:8210001,msg:"first frame rendering successful!"}};sendSDKCallbackToNative(callbackData)}};WLCG.startGameError=(code,message)=>{console.warn(`${(new Date).toTimeString().split(" ")[0]} - wl startGameError`,code,message);errCallback({code:"822"+code,msg:message})}}function createParentContainer(id){const dom=document.getElementById(id);const container=document.getElementById("container");if(dom){container.removeChild(dom)}const newDom=document.createElement("div");newDom.id=id;newDom.style.flex=1;container.appendChild(newDom)}function getLocationPlatform(){const query=window.location.search.substring(1);const vars=query.split("&");for(let i=0;i<vars.length;i++){const pair=vars[i].split("=");if(pair[0]=="zego_platform"){return pair[1].toLowerCase()}}return"undefined"}