"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

(function () {
  "use strict";

  var urlForInject = "#_urlForInject_#";
  var currentUrl = window.location.href;
  if (urlForInject != currentUrl) {
    console.log("ZenKitJsApi_JS: inject canceled, url changed. urlForInject=" + urlForInject + ", currentUrl=" + currentUrl);
    return;
  }
  console.log("ZenKitJsApi_JS: inject to url=" + currentUrl);

  if (window.ZENKIT) {
    console.log("ZenKitJsApi_JS: inject canceled, window.ZENKIT already found in this page");
    return;
  }

  var promises = {};
  var eventHandlers = {
    articleUpdate: [],
    scrollToComments: [],
    complain: [],
    edit: [],
    delete: [],
    notifications: [],
    pickerCancelled: [],
  };

  function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
  }

  function guid() {
    return s4() + s4() + "-" + s4() + "-" + s4() + "-" + s4() + "-" + s4() + s4() + s4();
  }

  window.handleZenKitPromiseResult = function (e) {
    var promise = promises[e.promiseId];

    if (e.status === 'SUCCESS') {
      promise.resolve(e.data);
    } else {
      promise.reject(new Error(e.error));
    }
  };

  window.onZenKitEvent = function (event) {
    console.log("ZenKitJsApi_JS: onZenKitEvent: " + event);
    eventHandlers[event.name].forEach(function (handler) {
      handler(event.data);
    });
  };

  window.ZENKIT = {
    on: function on(event, handler) {
      eventHandlers[event].push(handler);
      console.log("ZenKitJsApi_JS: added event handler: " + event);
    },
    off: function off(event, handler) {
      var index = eventHandlers[event].indexOf(handler);
      if (index >= 0) {
        eventHandlers[event].splice(index, 1);
        console.log("ZenKitJsApi_JS: removed event handler: " + event);
      } else {
        console.log("ZenKitJsApi_JS: handler not found for remove");
      }
    }
  };
  var zenkit = window.NATIVE_ZENKIT;

  var _loop = function _loop(methodName) {
    var fn = zenkit[methodName];

    ZENKIT[methodName] = function () {
      var args = arguments;
      var promiseId = guid();
      return new Promise(function (resolve, reject) {
        promises[promiseId] = {
          resolve: resolve,
          reject: reject
        };

        try {
          var processedArgs = Array.from(args).map(function (arg) {
            return _typeof(arg) === 'object' ? JSON.stringify(arg) : arg;
          });
          fn.apply(zenkit, [promiseId].concat(Array.from(processedArgs)));
        } catch (e) {
          reject(e);
        }
      });
    };
  };

  for (var methodName in zenkit) {
    _loop(methodName);
  }

  var launchOptions = #_launchOptions_#;

  if (!window.ZENKIT_LAUNCH_OPTIONS) {
    // If JS code from native injected before client's code
    window.ZENKIT_LAUNCH_OPTIONS = Promise.resolve(launchOptions);
  } else {
    // JS code from native injected after client's code
    window.ZENKIT_LAUNCH_OPTIONS.resolve(launchOptions);
  }
    console.log("ZenKitJsApi_JS: window.ZENKIT injected!");
})();
