local BlueFunctionNode = require "bluecore.functioncore.blue_func_node"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local AE = require "apolloengine"
local Types = require "venuscore.rtti.types"

local FuncInstanceNode = BlueFunctionNode:extend(); 
FuncInstanceNode:MemberRegister("ftnUid");
FuncInstanceNode:MemberRegister("libUid");
FuncInstanceNode:MemberRegister("funcType");
FuncInstanceNode:MemberRegister("comp", Types.ReferenceType(AE.BlueprintComponent:RTTI()));
--这个实例节点引用的函数是属于哪个blueprintcomponent的~

--函数实例节点
--该函数可能是局部函数也可能是全局函数

---- 游戏运行模式
function FuncInstanceNode:new(graph, funcType, ftnUid, libUid, comp) --这里的graph是blueprint或bluefunction
  LOG("FuncInstanceNode:new");
  FuncInstanceNode.super.new(self, graph)
  self.funcType = funcType;
  self.ftnUid = ftnUid;
  self.libUid = libUid;
  self.comp = comp;
  --self.isGraphBlueFunc = isGraphBlueFunc;
  -- 保留原来有的输出和输入执行引脚信息(可以为nil)
  local originExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local originExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  
  self.infoTable = {} -- 重新定义infoTable 元表的infoTable不变
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = {}
  self.infoTable[BD.PIN_EXEC_INPUT]  = originExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = originExecOutputsInfo


end


function FuncInstanceNode:_OnDuplicate()

  local luaPath = self[BD.LUA_CLASS_PATH];
  local clazz = require(luaPath); 
  local bluePrintNode = clazz(self.graph, self.funcType, self.ftnUid, self.libUid, self.comp); --new实例
  bluePrintNode[BD.LUA_CLASS_PATH] = luaPath;
  return bluePrintNode;
  -- body
end



function FuncInstanceNode:_OnInfoChange(reflectIdx, type, val, isInput)

  local pinDirect = isInput and BD.PIN_DATA_INPUT or BD.PIN_DATA_OUTPUT
  local curInfo = self.infoTable[pinDirect][reflectIdx]
  local pin = isInput and self.inputs or self.outputs
  pin = pin[reflectIdx]

  if type == BD.FuncInfoProp.Name then
    curInfo.name = val;
  elseif type == BD.FuncInfoProp.BaseType then
    curInfo:ChangeRtti(val, BU:GetDefaultByRtti(val));
    if isInput then
      self.inputs[reflectIdx].literal = BU:GenerateLiteral(curInfo.rtti, curInfo:GetDefault())
    end
  elseif type == BD.FuncInfoProp.Value then
    curInfo:ChangeDefault(val);
    self.inputs[reflectIdx].literal = BU:GenerateLiteral(curInfo.rtti, val)
  end
end

function FuncInstanceNode:_OnEditorPinDelete(isInput, idx)
  if isInput then
    local toDelInsPin = self.inputs[idx];
    self.graph:DeleteNodePin(toDelInsPin.uid);
    self:RemoveInput(idx);
  else
    local toDelInsPin = self.outputs[idx];
    self.graph:DeleteNodePin(toDelInsPin.uid);
    self:RemoveOutput(idx);
  end
end


function FuncInstanceNode:_OnEditorPinAdd(isInput, reflectInfo)
  local toAddInsPin = nil;
  if isInput then
    toAddInsPin = self:AddInput(reflectInfo);
  else  
    toAddInsPin = self:AddOutput(reflectInfo);
  end
  self.graph:AddBlueNodePinToAll(toAddInsPin);
end


function FuncInstanceNode:_OnCreateWithEditor()

  local blueGraph = BU.GetIns(self.comp)
  local funcIdx = self.funcType == BD.FuncType.LOCAL and self.ftnUid or self.libUid;
  local ftn = blueGraph.blueFunctionList[funcIdx];
  local reflectInputsInfo = ftn:GetInputInfo();
  local reflectOutputsInfo = ftn:GetOutputInfo();

  --此修改不影响元表值
  self.nodeName = ftn:GetName();
  -- 把原来的注册的数据引脚生成为动态的数据引脚
  if reflectInputsInfo ~= nil then
    for _, reflectInfo in pairs(reflectInputsInfo) do
      self:AddInput(reflectInfo); 
    end
  end

  -- 把原来的注册的数据引脚生成为动态的数据引脚
  if reflectOutputsInfo ~= nil then
    for _, reflectInfo in pairs(reflectOutputsInfo) do
      self:AddOutput(reflectInfo); 
    end
  end

  ftn:AddRefactor(self);
  
end

function FuncInstanceNode:_OnUpdate(args)
  self._CallFunction:_OnUpdate(args)
  return self._CallFunction:GetFunctionOutput()  -- OnUpdate
end

--_OnDeserialize 不关联任何数据的反序列化可以用
--_OnDeserializePost 具有关联性的数据反序列化使用
function FuncInstanceNode:_OnDeserializePost()

  --FuncInstanceNode.super:_OnDeserializePost()
  --反序列化会调用new函数 不用重新声明infotable
  local blueGraph = BU.GetIns(self.comp);
  local funcIdx = self.funcType == BD.FuncType.LOCAL and self.ftnUid or self.libUid;
  local ftn = blueGraph.blueFunctionList[funcIdx] ;
  local reflectInputsInfo = ftn:GetInputInfo();
  local reflectOutputsInfo = ftn:GetOutputInfo();
  self.nodeName = ftn:GetName();
  local newArgId = 1;
  for key, reflectInfo in pairs(reflectInputsInfo) do
    self:DynamicRegisterInput(newArgId, reflectInfo:GetRtti(), reflectInfo.name, reflectInfo.tips);
    newArgId = newArgId + 1;
  end
  newArgId = 1;
  for key, reflectInfo in pairs(reflectOutputsInfo) do
    self:DynamicRegisterOutput(newArgId, reflectInfo:GetRtti(), reflectInfo.name, reflectInfo.tips);
    newArgId = newArgId + 1;
  end

  ftn:AddRefactor(self);

end

function FuncInstanceNode:GetFunction()
  local blueGraph = BU.GetIns(self.comp)
  local funcIdx = self.funcType == BD.FuncType.LOCAL and self.ftnUid or self.libUid;
  local func = blueGraph.blueFunctionList[funcIdx];
  return func
end

function FuncInstanceNode:_OnCompile()
  self._CallFunction = nil
  local blueGraph = BU.GetIns(self.comp)
  local funcIdx = self.funcType == BD.FuncType.LOCAL and self.ftnUid or self.libUid;
  local func = blueGraph.blueFunctionList[funcIdx];
  if func == nil then
    self.compileResult = "function not found"
    return false ;
  end
  self._CallFunction = func ;
  return true ;
end

function FuncInstanceNode:_OnStop()
  self._CallFunction = nil
end

function FuncInstanceNode:ToBeDeletedEd()
  self._FtnToBeDelete = true
  self.graph:DeleteBlueNode(self.uid);
end

function FuncInstanceNode:_OnDeleteEd()
  if not self._FtnToBeDelete then
    local blueGraph = BU.GetIns(self.comp);
    local funcIdx = self.funcType == BD.FuncType.LOCAL and self.ftnUid or self.libUid;
    local ftn = blueGraph.blueFunctionList[funcIdx];
    ftn:RemoveRefactor(self);
  end
end

function FuncInstanceNode:NameChanged(oldName, newName)
  self.nodeName = newName
end


FuncInstanceNode:RegisterExecInput(1, "exec", "Execute");
FuncInstanceNode:RegisterExecOutput(1, "exec", "Execute");
FuncInstanceNode:SetFunctionType(BD.FUNCTION_INS_NODE)

return FuncInstanceNode ;


