local libvenuscore = require "libvenuscore"
local CmdMgr = require "window.editor.command.command_manager"

local BD = require "bluecore.bluedefined"
local BC = require "window.editor.command.commands.blueprintcomponent.blue_command"

local BlueWrap = libvenuscore.Object:extend();

function BlueWrap:new(cpath, wrapLabel)
  assert(cpath, "BlueWrap:new cpath nil ")
  self.cpath = cpath;
  self.wrapLabel = wrapLabel;
end

function BlueWrap:GetContentPath()
  return self.cpath
end

--当前blueeditor是蓝图函数 但需要支持增加blueprint的函数以及变量
function BlueWrap:SetwrapLabel(wrapLabel)
  self.wrapLabel = wrapLabel
end

function BlueWrap:GetwrapLabel(wrapLabel)
  return self.wrapLabel;
end

for _, funcName in ipairs(BD.BluePrintExportFtnArray) do
  BlueWrap[funcName] = function (self, ...)
    return CmdMgr:DoIt(BC[funcName](self.cpath, self.wrapLabel, ...));
  end
end

-- 命令封装blueprint
local CreateCompRefNode = require "window.editor.command.commands.blueprintcomponent.create_comp_ref_node"
BlueWrap["CreateCompRefNode"] = function (self, ...)
  return CmdMgr:DoIt(CreateCompRefNode(self.cpath, self.wrapLabel, ...));
end

-- 创建scriptcomponent的instance引用
local CreateScriptCompInsRefNode = require "window.editor.command.commands.blueprintcomponent.create_scriptcomp_ins_ref_node"
BlueWrap["CreateScriptCompInsRefNode"] = function (self, ...)
  return CmdMgr:DoIt(CreateScriptCompInsRefNode(self.cpath, self.wrapLabel, ...));
end

-- 创建cameracomponent的posteffect引用
local CreateCameraPostEffectRefNode = require "window.editor.command.commands.blueprintcomponent.create_camera_posteffect_ref_node"
BlueWrap["CreateCameraPostEffectRefNode"] = function (self, ...)
  return CmdMgr:DoIt(CreateCameraPostEffectRefNode(self.cpath, self.wrapLabel, ...));
end

local CreateBlueprintRefNodeEd = require "window.editor.command.commands.blueprintcomponent.create_blueprint_ref"
BlueWrap["CreateBlueprintRefNodeEd"] = function (self, blueComp, x, y)
  return CmdMgr:DoIt(CreateBlueprintRefNodeEd(self.cpath, self.wrapLabel, blueComp, x, y));
end


local AddBluePrintNode = require "window.editor.command.commands.blueprintcomponent.add_blue_print_node"
BlueWrap["AddBluePrintNode"] = function (self, ...)
  return CmdMgr:DoIt(AddBluePrintNode(self.cpath, self.wrapLabel, ...));
end

local CreateVarRefNode = require "window.editor.command.commands.blueprintcomponent.create_variable_ref_node"
BlueWrap["CreateVarRefNode"] = function (self, ...)
  return CmdMgr:DoIt(CreateVarRefNode(self.cpath, self.wrapLabel, ...));
end

-- blueprint component 的接口
local AppendSource  = require "window.editor.command.commands.blueprintcomponent.append_source"
BlueWrap["AppendSource"] = function (self, ...)
  return CmdMgr:DoIt(AppendSource(self.cpath, ...));
end

local RemoveSource  = require "window.editor.command.commands.blueprintcomponent.remove_source"
BlueWrap["RemoveSource"] = function (self, ...)
  return CmdMgr:DoIt(RemoveSource(self.cpath, ...));
end

local AddBluePrintNodeEd = require "window.editor.command.commands.blueprintcomponent.add_blue_print_node_ed"
BlueWrap["AddBluePrintNodeEd"] = function (self, ...)
  return CmdMgr:DoIt(AddBluePrintNodeEd(self.cpath, self.wrapLabel, ...));
end

return BlueWrap