
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local MakeVector3fFromVec2 = BlueNode:extend();

---- 游戏运行模式
function MakeVector3fFromVec2:new(...)
  MakeVector3fFromVec2.super.new(self, ...)
end

function MakeVector3fFromVec2:_OnUpdate(args)
  return mathfunction.vector3(args[1]:x(), args[1]:y(), args[2]);
end


---- 编辑器模式
MakeVector3fFromVec2:RegisterInput(1, mathfunction.vector2:RTTI(), "vec2f", "vec2f",  mathfunction.vector2(0,0));
MakeVector3fFromVec2:RegisterInput(2, Types.FloatType, "z", "z", 0.0);

MakeVector3fFromVec2:RegisterOutput(1, mathfunction.vector3:RTTI(), "return vector3f", "创建向量(x,y,z)");

MakeVector3fFromVec2:SetFunctionName("Make Vec3f From Vec2f");

MakeVector3fFromVec2:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return MakeVector3fFromVec2 ;