local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local IsPointInRectangle = BlueNode:extend();
local BD = require "bluecore.bluedefined"

---- 游戏运行模式
function IsPointInRectangle:new(...)
  IsPointInRectangle.super.new(self, ...)
end

function IsPointInRectangle:_OnUpdate(args)
  local point = args[1];
  local rectangle = args[2];
  local size = args[3];
  --[[local res1 = point.mx >= rectangle.mx;
  local res2 = point.mx <= rectangle.mx + size.mx;
  local res3 = point.my >= rectangle.my - size.my;
  local res4 = point.my <= rectangle.my;
  local ressult = res1 and res2 and res3 and res4;]]--
  local ressult = point.mx >= rectangle.mx 
                  and point.mx <= rectangle.mx + size.mx
                  and point.my >= rectangle.my - size.my
                  and point.my <= rectangle.my;
  return ressult;
end


---- 编辑器模式
IsPointInRectangle:RegisterInput(1, mf.vector2():RTTI(), "point", "点坐标", mf.vector2(0.5,0.5));
IsPointInRectangle:RegisterInput(2, mf.vector2():RTTI(), "leftup", "左上角点坐标", mf.vector2(0.0,1.0));
IsPointInRectangle:RegisterInput(3, mf.vector2():RTTI(), "size", "长方形宽高", mf.vector2(1.0,1.0));
IsPointInRectangle:RegisterOutput(1, Types.BoolType, "inner", "点是否在长方形内(此节点只适用长方形的边平行笛卡尔坐标系)");
IsPointInRectangle:SetFunctionName("Is Point In Rectangle");
IsPointInRectangle:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return IsPointInRectangle ;