local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"
local AE = require "apolloengine"

local UserEvent = BlueNode:extend();

---- 游戏运行模式
function UserEvent:new(...)
  UserEvent.super.new(self, ...)
end

function UserEvent:_OnUpdate(args)
  return args
end

function UserEvent:RegisterTriggerFunc(func, bluePrintSelf)

  self:_GetInput()

  local type = self.inputArgs[1];

  EventDispatcher:RegisterCallback(BD.Event.UserEventComponent, type , func, bluePrintSelf);
end

---- 编辑器模式
local ComboType = require "venuscore.rtti.types.combotype"
local UserEventComboType = ComboType:extend("UserEventComboType");

if _KRATOSEDITOR then
  local eventArrays = AE.BlueprintComponent:GetUserEvents();
  local eventValues = {}
  local eventNames = {}
  for key, value in ipairs(eventArrays) do
    table.insert(eventValues, key);
    table.insert(eventNames, value);
  end
  UserEventComboType:SetData(eventValues, eventNames);
end

UserEvent:RegisterInput(1, UserEventComboType, "event", "User Event Type", 0)
UserEvent:RegisterOutput(1, Types.FloatType, "extra", "extra") -- 预留

UserEvent:RegisterExecOutput(1, "OnEvent", "执行");

UserEvent:SetFunctionName("UserEvent");

UserEvent:SetFunctionType(BD.EVENT_FUNCTION_NODE);
UserEvent:SetEventType(BD.EventType.RegisterCallback);

return UserEvent;

