local Types = require "venuscore.rtti.types"
local BDATNode = require "bluecore.base.blue_dynamic_anytype_pins_node"
local BD = require "bluecore.bluedefined"

-- 全部触发就执行
local GoIfAllTrigger = BDATNode:extend();

function GoIfAllTrigger:new(...)
	GoIfAllTrigger.super.new(self,...);
  self.currentTrigger = 0   -- 当前触发的数目
  self.totalTrigger = 0     -- 执行引脚数目
  self.currentStatus = false-- 当前帧触发的状态 true-高电平
  self.isEdge = false       -- 是否边沿触发
end

function GoIfAllTrigger:Update(execIdx)

  if self.totalTrigger == 0 then
    self.totalTrigger = #self.execInputs; -- 执行引脚数目

    self:_GetInput();
    self.isEdge = self.inputArgs[1]
  end

  if execIdx ~= nil then
    self.currentTrigger = self.currentTrigger + 1
  end

  if execIdx ~= nil and self.currentTrigger == self.totalTrigger then
    local trigger = false
    if self.isEdge and not self.currentStatus then
      trigger = true
    elseif not self.isEdge then
      trigger = true
    end
    self.currentStatus = true
    if trigger then
      return 1;
    end

  end
end

-- record start
function GoIfAllTrigger:_OnReset()
  self.currentTrigger = 0
  self.currentStatus = false
end

function GoIfAllTrigger:_OnTick(delta)
  if self.currentTrigger ~= self.totalTrigger then
    self.currentStatus = false
  end
  self.currentTrigger = 0
end

-- 增删引脚相关
function GoIfAllTrigger:_OnOrderChange(pinInfo, oldIdx, newIdx)
  pinInfo.name = "Exec In ["..(newIdx).."]"
  pinInfo.tips = "Exec In ["..(newIdx).."]"
  --WARNING("pinInfo Update "..tostring(pinInfo.name)..","..tostring(pinInfo.tips))
end

GoIfAllTrigger._OnAdd = function(thisNode)
  local pinUid = thisNode.graph:_NextID();
  local nodeUid = thisNode.uid;
  local newArgId = 1
  for _ , __ in pairs(thisNode[BD.EXEC_INPUTS_INFO]) do
    newArgId = newArgId + 1
  end
  local inputPin = thisNode:AppendExecInput(Types.ExecPinType, "Exec In ["..(newArgId).."]", "Execute", nil, pinUid, nodeUid, true);
  return inputPin
end

GoIfAllTrigger._OnDel = function(thisNode, execOutputPin)
  thisNode:RemoveExecInput(execOutputPin);
  return true
end


GoIfAllTrigger:RegisterInput(1, Types.BoolType, "Edge", "Trigger when 0->1" , true) -- 只在第一次update时候获取
GoIfAllTrigger:RegisterExecInput(1, "Exec In [1]", "Execute", false, false); -- abort false, delable false
GoIfAllTrigger:RegisterExecInput(2, "Exec In [2]", "Execute", true, false);  -- abort true, delable false
GoIfAllTrigger:RegisterExecOutput(1, "trigger", "onTrigger");
GoIfAllTrigger:SetFunctionName("Go If All Trigger");

GoIfAllTrigger:RegisterMoreExecInput("exec",
        BD.OP_ADD, "增加输入执行引脚", GoIfAllTrigger._OnAdd,
        BD.OP_DEL, "删除输入执行引脚", GoIfAllTrigger._OnDel);

GoIfAllTrigger:RegisterOnTick(GoIfAllTrigger._OnTick)
return GoIfAllTrigger;