local BD = require "bluecore.bluedefined"
local BATNode = require "bluecore.base.blue_anytype_node"
local Types = require "venuscore.rtti.types"

local SetArrayElementByIndex = BATNode:extend();

---- 游戏运行模式
function SetArrayElementByIndex:new(...)
  SetArrayElementByIndex.super.new(self, ...)
end

function SetArrayElementByIndex:_OnUpdate(args)
  local array = args[1]
  local index = args[2]
  local new_element = args[3];

  if array == nil then
    ERROR("[SetArrayElementByIndex] array is nil")
    return nil;
  end
  if new_element == nil then
    ERROR("[SetArrayElementByIndex] new_element is nil")
    return array;
  end
  if index <= 0 or index > #array then
    ERROR("[SetArrayElementByIndex] index "..tostring(index).." is illegal ".."legal range is [1,"..tostring(#array).."]");
    return array;
  end
  array[index] = new_element;
  return array;
end

---- 编辑器模式
SetArrayElementByIndex:RegisterExecInput(1, "Exec", "执行");
SetArrayElementByIndex:RegisterExecOutput(1, "Exec", "执行");

SetArrayElementByIndex:RegisterInput(1, Types.AnyArrayType, "Array", "通配数组", Types.AnyArrayType(), false, BATNode.DEFAULT_GROUP);
SetArrayElementByIndex:RegisterInput(2, Types.IntType, "Index", "数组索引(从1开始)", 1, false, nil)
SetArrayElementByIndex:RegisterInput(3, Types.AnyType, "element_new", "新元素值", Types.AnyType(), false, BATNode.DEFAULT_GROUP);
SetArrayElementByIndex:RegisterOutput(1, Types.AnyArrayType, "result", "输出数组", Types.AnyArrayType(), false , BATNode.DEFAULT_GROUP);

SetArrayElementByIndex:SetFunctionName("Set Array Element");

return SetArrayElementByIndex ;