


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetLocalScale = BlueNode:extend();

---- 游戏运行模式
function SetLocalScale:new(...)
  SetLocalScale.super.new(self, ...)
end

function SetLocalScale:_OnUpdate(args)
  local transformComponent_target = args[1];
  local vec3f_scale = args[2];
  transformComponent_target:SetLocalScale(vec3f_scale);

  return true;
end



---- 编辑器模式



SetLocalScale:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
SetLocalScale:RegisterInput(2, mathfunction.vector3:RTTI(), "scale", "设置target在模型坐标系下的缩放", mathfunction.vector3(1.0,1.0,1.0));

SetLocalScale:RegisterOutput(1, Types.BoolType, "result", "设置成功返回true");

SetLocalScale:RegisterExecInput(1, "exec", "执行");

SetLocalScale:RegisterExecOutput(1, "exec", "执行");

SetLocalScale:SetFunctionName("SetLocalScale");


return SetLocalScale ;

