local AE = require "apolloengine"
local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local FromNDCToWorld = BlueNode:extend();

function FromNDCToWorld:new(...)
  FromNDCToWorld.super.new(self,...)
end

function FromNDCToWorld:_OnUpdate(args)
  local hostNodeTrans = args[1];
  local hostCam = args[2];
  local ndcPos = args[3];
  local isNdc = args[4];
  local nx = ndcPos.mx
  local ny = ndcPos.my
  if not isNdc then -- device space, origin is left-top
    nx = nx * 2 - 1 ;
    --ny = (1 - ny) * 2 - 1
    ny = 1 - 2 * ny
  end -- standard space, origin is screen-center
  local hostNodePos = hostNodeTrans:GetWorldPosition();
  local cameraViewProj = hostCam:GetViewProj();
  local cameraViewProjInv = cameraViewProj:Inverse();
  local currentClip = mf.vector4(hostNodePos.mx, hostNodePos.my, hostNodePos.mz, 1.0) * cameraViewProj;
  local newClip = mf.vector4(nx, ny, currentClip.mz/currentClip.mw, 1.0);
  local newWorld = newClip * cameraViewProjInv;
  if hostCam.ProjectionType ~= 2.0 then
    newWorld = newWorld / newWorld.mw;
  end
  return mf.vector3(newWorld.mx, newWorld.my, newWorld.mz);
end


FromNDCToWorld:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "TransformComponent", BlueSelf());
FromNDCToWorld:RegisterInput(2, AE.CameraComponent:RTTI(), "target", "CameraComponent", BlueSelf());
FromNDCToWorld:RegisterInput(3, mf.vector2:RTTI(), "screenPos", "2d position", mf.vector2(0.0,0.0));
FromNDCToWorld:RegisterInput(4, Types.BoolType, "use standard space", "standard space(center):[-1,1], device space(bvt,left-top):[0,1]",  true);

FromNDCToWorld:RegisterOutput(1, mf.vector3:RTTI(), "worldPos", "世界坐标");

FromNDCToWorld:RegisterExecInput(1, "exec", "执行");
FromNDCToWorld:RegisterExecOutput(1, "exec", "执行");

FromNDCToWorld:SetFunctionName("NDC->World");


return FromNDCToWorld;
