local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectScalar = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectScalar:new(...)
  SetPostEffectScalar.super.new(self, ...)
end



function SetPostEffectScalar:_IsRightType(value)
  --local vec1 = type(value) == "userdata" and value:RTTI() == mathfunction.vector1():RTTI();
  local scalar = type(value) == "number";
  return scalar;
end



SetPostEffectScalar:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectScalar:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 
SetPostEffectScalar:RegisterInput(3, Types.FloatType, "ParaValue", "参数值", 1.0);


SetPostEffectScalar:RegisterExecInput(1, "exec", "执行");

SetPostEffectScalar:RegisterExecOutput(1, "exec", "执行");

SetPostEffectScalar:SetFunctionName("SetPostEffectScalar");

return SetPostEffectScalar ;

