local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectVector3 = GetPostEffectValue:extend();


---- 游戏运行模式
function GetPostEffectVector3:new(...)
  GetPostEffectVector3.super.new(self, ...)
end




function GetPostEffectVector3:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector3:RTTI();
end



GetPostEffectVector3:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectVector3:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 

GetPostEffectVector3:RegisterOutput(1, mathfunction.vector3:RTTI(), "ParaValue", "参数值");

GetPostEffectVector3:SetFunctionName("GetPostEffectVector3");


return GetPostEffectVector3 ;

