local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local LightDot = {}
LightDot.DoMaterial = 0;
LightDot.DoRenderObj = 0;
LightDot.Queue = 310;

function LightDot:Initialize(host, size)
  self.uv_dotRadius = mathfunction.vector1(0.0);
  self.uv_dotInternal = mathfunction.vector1(0.0);
  self.angle_channel = mathfunction.vector1(0.0);
  self.contrastFactor = mathfunction.vector1(0.0);
  self.half_toneFactor = mathfunction.vector1(0.0);
  self.SourceTex     = apolloengine.TextureEntity();
  self.soft_lightAlpha = mathfunction.vector1(0.0);
  self.threshold = mathfunction.vector1(0.0);
  self.gradient = mathfunction.vector1(2.0);

  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");
  self.UV_DOT_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "UV_DOT_RADIUS");
  self.UV_DOT_INTERNAL = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "UV_DOT_INTERNAL");
  self.ANGLE_CHANNEL = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "ANGLE_CHANNEL");
  self.CONTRAST_FACTOR = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "CONTRAST_FACTOR");
  self.HALF_TONE_FACTOR = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "HALF_TONE_FACTOR");

  self.TEXTURE_DIFFUSE2 = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TEXTURE_DIFFUSE2");

  self.SOFT_LIGHT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SOFT_LIGHT_ALPHA");
  self.THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "THRESHOLD");
  self.GRADIENT = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "GRADIENT");


  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/light_dot.material");
  self.DoMaterial = host:CreateMaterial(pathout);
  self.DoRenderObj = host:CreateRenderObject();

  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
  self.DoMaterial:SetParameter(self.UV_DOT_RADIUS, self.uv_dotRadius);
  self.DoMaterial:SetParameter(self.UV_DOT_INTERNAL, self.uv_dotInternal);
  self.DoMaterial:SetParameter(self.ANGLE_CHANNEL, self.angle_channel);
  self.DoMaterial:SetParameter(self.CONTRAST_FACTOR, self.contrastFactor);
  self.DoMaterial:SetParameter(self.HALF_TONE_FACTOR, self.half_toneFactor);
  self.DoMaterial:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
  self.DoMaterial:SetParameter(self.SOFT_LIGHT_ALPHA, self.soft_lightAlpha);
  self.DoMaterial:SetParameter(self.THRESHOLD, self.threshold);
  self.DoMaterial:SetParameter(self.GRADIENT, self.gradient);

  host:RegisterScriptParameter(self,"uv_dotRadius");
  host:RegisterScriptParameter(self,"uv_dotInternal");
  host:RegisterScriptParameter(self,"angle_channel");
  host:RegisterScriptParameter(self,"contrastFactor");
  host:RegisterScriptParameter(self,"half_toneFactor");
  host:RegisterScriptParameter(self, "SourceTex");
  host:RegisterScriptParameter(self, "soft_lightAlpha");
  host:RegisterScriptParameter(self, "threshold");
  host:RegisterScriptParameter(self, "gradient");
  return self.Queue;
end



function LightDot:Resizeview(size)
  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
end

function LightDot:Process(context, Original, Scene, Output)

--   Output:PushRenderTarget();
--   Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.DoMaterial:SetParameter(self.UV_DOT_RADIUS, self.uv_dotRadius);
  self.DoMaterial:SetParameter(self.UV_DOT_INTERNAL, self.uv_dotInternal);
  self.DoMaterial:SetParameter(self.ANGLE_CHANNEL, self.angle_channel);
  self.DoMaterial:SetParameter(self.CONTRAST_FACTOR, self.contrastFactor);
  self.DoMaterial:SetParameter(self.HALF_TONE_FACTOR, self.half_toneFactor);
  self.DoMaterial:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
  self.DoMaterial:SetParameter(self.SOFT_LIGHT_ALPHA, self.soft_lightAlpha);
  self.DoMaterial:SetParameter(self.THRESHOLD, self.threshold);
  self.DoMaterial:SetParameter(self.GRADIENT, self.gradient);
  context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();
	-- self.Do:Draw(pipeline);
end

return LightDot;